/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.reader;

import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitState;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplitState;
import org.apache.flink.cdc.connectors.base.source.meta.wartermark.WatermarkEvent;
import org.apache.flink.cdc.connectors.base.source.metrics.SourceReaderMetrics;
import org.apache.flink.cdc.connectors.base.source.reader.IncrementalSourceRecordEmitter;
import org.apache.flink.cdc.connectors.mongodb.source.offset.ChangeStreamOffset;
import org.apache.flink.cdc.connectors.mongodb.source.utils.MongoRecordUtils;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDBRecordEmitter<T>
extends IncrementalSourceRecordEmitter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBRecordEmitter.class);

    public MongoDBRecordEmitter(DebeziumDeserializationSchema<T> deserializationSchema, SourceReaderMetrics sourceReaderMetrics, OffsetFactory offsetFactory) {
        super(deserializationSchema, sourceReaderMetrics, false, offsetFactory);
    }

    protected void processElement(SourceRecord element, SourceOutput<T> output, SourceSplitState splitState) throws Exception {
        if (WatermarkEvent.isWatermarkEvent((SourceRecord)element)) {
            Offset watermark = this.getOffsetPosition(element);
            if (WatermarkEvent.isHighWatermarkEvent((SourceRecord)element) && splitState.isSnapshotSplitState()) {
                splitState.asSnapshotSplitState().setHighWatermark(watermark);
            }
        } else if (MongoRecordUtils.isHeartbeatEvent(element)) {
            if (splitState.isStreamSplitState()) {
                this.updatePositionForStreamSplit(element, splitState);
            }
        } else if (MongoRecordUtils.isDataChangeRecord(element)) {
            if (splitState.isStreamSplitState()) {
                this.updatePositionForStreamSplit(element, splitState);
            }
            this.reportMetrics(element);
            this.emitElement(element, output);
        } else {
            LOG.info("Meet unknown element {}, just skip.", (Object)element);
            this.sourceReaderMetrics.addNumRecordsInErrors(1L);
        }
    }

    private void updatePositionForStreamSplit(SourceRecord element, SourceSplitState splitState) {
        BsonDocument resumeToken = MongoRecordUtils.getResumeToken(element);
        StreamSplitState streamSplitState = splitState.asStreamSplitState();
        ChangeStreamOffset offset = (ChangeStreamOffset)streamSplitState.getStartingOffset();
        if (offset != null) {
            offset.updatePosition(resumeToken);
        }
        splitState.asStreamSplitState().setStartingOffset((Offset)offset);
    }

    protected void reportMetrics(SourceRecord element) {
        Long fetchTimestamp;
        Long messageTimestamp = MongoRecordUtils.getMessageTimestamp(element);
        if (messageTimestamp != null && messageTimestamp > 0L && (fetchTimestamp = MongoRecordUtils.getFetchTimestamp(element)) != null && fetchTimestamp >= messageTimestamp) {
            this.sourceReaderMetrics.recordFetchDelay(fetchTimestamp - messageTimestamp);
        }
    }
}

