/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.mongodb.source.MongoDBSource;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceConfigFactory;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.util.Preconditions;

@Experimental
@PublicEvolving
public class MongoDBSourceBuilder<T> {
    private final MongoDBSourceConfigFactory configFactory = new MongoDBSourceConfigFactory();
    private DebeziumDeserializationSchema<T> deserializer;

    public MongoDBSourceBuilder<T> scheme(String scheme) {
        this.configFactory.scheme(scheme);
        return this;
    }

    public MongoDBSourceBuilder<T> hosts(String hosts) {
        this.configFactory.hosts(hosts);
        return this;
    }

    public MongoDBSourceBuilder<T> connectionOptions(String connectionOptions) {
        this.configFactory.connectionOptions(connectionOptions);
        return this;
    }

    public MongoDBSourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public MongoDBSourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public MongoDBSourceBuilder<T> databaseList(String ... databases) {
        this.configFactory.databaseList((String[])Arrays.stream(databases).flatMap(database -> Stream.of(database.split(","))).toArray(String[]::new));
        return this;
    }

    public MongoDBSourceBuilder<T> collectionList(String ... collections) {
        this.configFactory.collectionList((String[])Arrays.stream(collections).flatMap(collection -> Stream.of(collection.split(","))).toArray(String[]::new));
        return this;
    }

    public MongoDBSourceBuilder<T> batchSize(int batchSize) {
        this.configFactory.batchSize(batchSize);
        return this;
    }

    public MongoDBSourceBuilder<T> pollAwaitTimeMillis(int pollAwaitTimeMillis) {
        Preconditions.checkArgument((pollAwaitTimeMillis > 0 ? 1 : 0) != 0);
        this.configFactory.pollAwaitTimeMillis(pollAwaitTimeMillis);
        return this;
    }

    public MongoDBSourceBuilder<T> pollMaxBatchSize(int pollMaxBatchSize) {
        this.configFactory.pollMaxBatchSize(pollMaxBatchSize);
        return this;
    }

    public MongoDBSourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public MongoDBSourceBuilder<T> heartbeatIntervalMillis(int heartbeatIntervalMillis) {
        this.configFactory.heartbeatIntervalMillis(heartbeatIntervalMillis);
        return this;
    }

    public MongoDBSourceBuilder<T> splitSizeMB(int splitSizeMB) {
        this.configFactory.splitSizeMB(splitSizeMB);
        return this;
    }

    public MongoDBSourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public MongoDBSourceBuilder<T> samplesPerChunk(int samplesPerChunk) {
        this.configFactory.samplesPerChunk(samplesPerChunk);
        return this;
    }

    public MongoDBSourceBuilder<T> closeIdleReaders(boolean closeIdleReaders) {
        this.configFactory.closeIdleReaders(closeIdleReaders);
        return this;
    }

    public MongoDBSourceBuilder<T> scanFullChangelog(boolean enableFullDocPrePostImage) {
        this.configFactory.scanFullChangelog(enableFullDocPrePostImage);
        return this;
    }

    public MongoDBSourceBuilder<T> disableCursorTimeout(boolean disableCursorTimeout) {
        this.configFactory.disableCursorTimeout(disableCursorTimeout);
        return this;
    }

    public MongoDBSourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public MongoDBSourceBuilder<T> skipSnapshotBackfill(boolean skipSnapshotBackfill) {
        this.configFactory.skipSnapshotBackfill(skipSnapshotBackfill);
        return this;
    }

    public MongoDBSourceBuilder<T> scanNewlyAddedTableEnabled(boolean scanNewlyAddedTableEnabled) {
        this.configFactory.scanNewlyAddedTableEnabled(scanNewlyAddedTableEnabled);
        return this;
    }

    public MongoDBSource<T> build() {
        return new MongoDBSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer));
    }
}

