/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.utils;

import java.time.ZoneId;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.mongodb.table.MongoDBConnectorDeserializationSchema;
import org.apache.flink.cdc.connectors.mongodb.table.MongoDBConnectorFullChangelogDeserializationSchema;
import org.apache.flink.cdc.connectors.mongodb.utils.RecordsFormatter;
import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.RowRowConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.kafka.connect.source.SourceRecord;

public class TestTable {
    private final String databaseName;
    private final String tableName;
    private final ResolvedSchema schema;
    private RowRowConverter rowRowConverter;
    private MongoDBConnectorDeserializationSchema deserializer;
    private RecordsFormatter recordsFormatter;
    private String serverTimeZone;

    public TestTable(String databaseName, String tableName, ResolvedSchema schema) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.schema = schema;
    }

    public RowType getRowType() {
        return (RowType)this.schema.toPhysicalRowDataType().getLogicalType();
    }

    public MongoDBConnectorDeserializationSchema getDeserializer(boolean enableFullDocPrePostImage) {
        if (this.deserializer == null) {
            this.deserializer = enableFullDocPrePostImage ? new MongoDBConnectorFullChangelogDeserializationSchema(this.getRowType(), new MetadataConverter[0], (TypeInformation)InternalTypeInfo.of((RowType)this.getRowType()), ZoneId.of("UTC")) : new MongoDBConnectorDeserializationSchema(this.getRowType(), new MetadataConverter[0], (TypeInformation)InternalTypeInfo.of((RowType)this.getRowType()), ZoneId.of("UTC"));
        }
        return this.deserializer;
    }

    public RowRowConverter getRowRowConverter() {
        if (this.rowRowConverter == null) {
            this.rowRowConverter = RowRowConverter.create((DataType)this.schema.toPhysicalRowDataType());
        }
        return this.rowRowConverter;
    }

    public RecordsFormatter getRecordsFormatter() {
        if (this.recordsFormatter == null) {
            this.recordsFormatter = new RecordsFormatter(this.schema.toPhysicalRowDataType());
        }
        return this.recordsFormatter;
    }

    public String stringify(RowData rowData) {
        return this.getRowRowConverter().toExternal(rowData).toString();
    }

    public List<String> stringify(List<SourceRecord> sourceRecord) {
        return this.getRecordsFormatter().format(sourceRecord);
    }
}

