/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.nonha.embedded.HaLeadershipControl;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.types.Row;
import org.junit.Assert;

public class MongoDBTestUtils {
    public static void waitForSnapshotStarted(String sinkName) throws InterruptedException {
        while (MongoDBTestUtils.sinkSize(sinkName) == 0) {
            Thread.sleep(100L);
        }
    }

    public static void waitForSinkSize(String sinkName, int expectedSize) throws InterruptedException {
        MongoDBTestUtils.waitForSinkSize(sinkName, expectedSize, 10L, TimeUnit.MINUTES);
    }

    public static void waitForSinkSize(String sinkName, int expectedSize, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        while (MongoDBTestUtils.sinkSize(sinkName) < expectedSize) {
            if (System.nanoTime() > deadline) {
                Assert.fail((String)("Wait for sink size timeout, raw results: \n" + String.join((CharSequence)"\n", TestValuesTableFactory.getRawResults((String)sinkName))));
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sinkSize(String sinkName) {
        Class<TestValuesTableFactory> clazz = TestValuesTableFactory.class;
        synchronized (TestValuesTableFactory.class) {
            try {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return TestValuesTableFactory.getRawResults((String)sinkName).size();
            }
            catch (IllegalArgumentException e) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
        }
    }

    public static List<String> fetchRowData(Iterator<RowData> iter, int size, Function<RowData, String> stringifier) {
        ArrayList<RowData> rows = new ArrayList<RowData>(size);
        while (size > 0 && iter.hasNext()) {
            RowData row = iter.next();
            rows.add(row);
            --size;
        }
        return rows.stream().map(stringifier).collect(Collectors.toList());
    }

    public static List<String> fetchRows(Iterator<Row> iter, int size) {
        ArrayList<String> rows = new ArrayList<String>(size);
        while (size > 0 && iter.hasNext()) {
            Row row = iter.next();
            rows.add(row.toString());
            --size;
        }
        return rows;
    }

    public static void triggerFailover(FailoverType type, JobID jobId, MiniCluster miniCluster, Runnable afterFailAction) throws Exception {
        switch (type) {
            case TM: {
                MongoDBTestUtils.restartTaskManager(miniCluster, afterFailAction);
                break;
            }
            case JM: {
                MongoDBTestUtils.triggerJobManagerFailover(jobId, miniCluster, afterFailAction);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
            }
        }
    }

    public static void triggerJobManagerFailover(JobID jobId, MiniCluster miniCluster, Runnable afterFailAction) throws Exception {
        HaLeadershipControl haLeadershipControl = (HaLeadershipControl)miniCluster.getHaLeadershipControl().get();
        haLeadershipControl.revokeJobMasterLeadership(jobId).get();
        afterFailAction.run();
        haLeadershipControl.grantJobMasterLeadership(jobId).get();
    }

    public static void restartTaskManager(MiniCluster miniCluster, Runnable afterFailAction) throws Exception {
        miniCluster.terminateTaskManager(0).get();
        afterFailAction.run();
        miniCluster.startTaskManager();
    }

    public static enum FailoverPhase {
        SNAPSHOT,
        STREAM,
        NEVER;

    }

    public static enum FailoverType {
        TM,
        JM,
        NONE;

    }
}

