/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.utils;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.mongodb.client.model.changestream.OperationType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;

public class MongoDBAssertUtils {
    public static void assertObjectIdEquals(String expect, SourceRecord actual) {
        String actualOid = ((Struct)actual.value()).getString("documentKey");
        Assert.assertEquals((Object)expect, (Object)JsonPath.read((String)actualOid, (String)"$._id.$oid", (Predicate[])new Predicate[0]));
    }

    public static void assertInsert(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assert.assertNotNull((Object)record.key());
            Assert.assertNotNull((Object)record.keySchema());
        } else {
            Assert.assertNull((Object)record.key());
            Assert.assertNull((Object)record.keySchema());
        }
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)OperationType.INSERT.getValue(), (Object)value.getString("operationType"));
        Assert.assertNotNull((Object)value.get("fullDocument"));
        Assert.assertNotNull((Object)value.get("documentKey"));
    }

    public static void assertUpdate(SourceRecord record) {
        Assert.assertNotNull((Object)record.key());
        Assert.assertNotNull((Object)record.keySchema());
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)OperationType.UPDATE.getValue(), (Object)value.getString("operationType"));
        Assert.assertNotNull((Object)value.get("documentKey"));
        Assert.assertNotNull((Object)value.get("fullDocument"));
    }

    public static void assertUpdate(SourceRecord record, String idValue) {
        MongoDBAssertUtils.assertUpdate(record);
        MongoDBAssertUtils.assertObjectIdEquals(idValue, record);
    }

    public static void assertReplace(SourceRecord record) {
        Assert.assertNotNull((Object)record.key());
        Assert.assertNotNull((Object)record.keySchema());
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)OperationType.REPLACE.getValue(), (Object)value.getString("operationType"));
        Assert.assertNotNull((Object)value.get("documentKey"));
        Assert.assertNotNull((Object)value.get("fullDocument"));
    }

    public static void assertReplace(SourceRecord record, String idValue) {
        MongoDBAssertUtils.assertReplace(record);
        MongoDBAssertUtils.assertObjectIdEquals(idValue, record);
    }

    public static void assertDelete(SourceRecord record) {
        Assert.assertNotNull((Object)record.key());
        Assert.assertNotNull((Object)record.keySchema());
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)OperationType.DELETE.getValue(), (Object)value.getString("operationType"));
        Assert.assertNotNull((Object)value.get("documentKey"));
    }

    public static void assertDelete(SourceRecord record, String idValue) {
        MongoDBAssertUtils.assertDelete(record);
        MongoDBAssertUtils.assertObjectIdEquals(idValue, record);
    }

    public static void assertEqualsInAnyOrder(List<String> expected, List<String> actual) {
        Assert.assertTrue((expected != null && actual != null ? 1 : 0) != 0);
        MongoDBAssertUtils.assertEqualsInOrder(expected.stream().sorted().collect(Collectors.toList()), actual.stream().sorted().collect(Collectors.toList()));
    }

    public static void assertEqualsInOrder(List<String> expected, List<String> actual) {
        Assert.assertTrue((expected != null && actual != null ? 1 : 0) != 0);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertArrayEquals((Object[])expected.toArray(new String[0]), (Object[])actual.toArray(new String[0]));
    }
}

