/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.table;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.connectors.base.options.SourceOptions;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.mongodb.source.config.MongoDBSourceOptions;
import org.apache.flink.cdc.connectors.mongodb.table.MongoDBTableSource;
import org.apache.flink.cdc.connectors.utils.AssertUtils;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.cdc.debezium.utils.ResolvedSchemaUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.runtime.connector.source.ScanRuntimeProviderContext;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class MongoDBTableFactoryTest {
    private static final ResolvedSchema SCHEMA = new ResolvedSchema(Arrays.asList(Column.physical((String)"_id", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"bbb", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"ccc", (DataType)DataTypes.DOUBLE()), Column.physical((String)"ddd", (DataType)DataTypes.DECIMAL((int)31, (int)18)), Column.physical((String)"eee", (DataType)DataTypes.TIMESTAMP((int)3))), Collections.emptyList(), UniqueConstraint.primaryKey((String)"pk", Arrays.asList("_id")));
    private static final ResolvedSchema SCHEMA_WITH_METADATA = new ResolvedSchema(Arrays.asList(Column.physical((String)"_id", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"bbb", (DataType)((DataType)DataTypes.STRING().notNull())), Column.physical((String)"ccc", (DataType)DataTypes.DOUBLE()), Column.physical((String)"ddd", (DataType)DataTypes.DECIMAL((int)31, (int)18)), Column.physical((String)"eee", (DataType)DataTypes.TIMESTAMP((int)3)), Column.metadata((String)"time", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), (String)"op_ts", (boolean)true), Column.metadata((String)"_database_name", (DataType)DataTypes.STRING(), (String)"database_name", (boolean)true)), Collections.emptyList(), UniqueConstraint.primaryKey((String)"pk", Collections.singletonList("_id")));
    private static final String MY_HOSTS = "localhost:27017,localhost:27018";
    private static final String USER = "flinkuser";
    private static final String PASSWORD = "flinkpw";
    private static final String MY_DATABASE = "myDB";
    private static final String MY_TABLE = "myTable";
    private static final ZoneId LOCAL_TIME_ZONE = ZoneId.systemDefault();
    private static final int BATCH_SIZE_DEFAULT = (Integer)MongoDBSourceOptions.BATCH_SIZE.defaultValue();
    private static final int POLL_MAX_BATCH_SIZE_DEFAULT = (Integer)MongoDBSourceOptions.POLL_MAX_BATCH_SIZE.defaultValue();
    private static final int POLL_AWAIT_TIME_MILLIS_DEFAULT = (Integer)MongoDBSourceOptions.POLL_AWAIT_TIME_MILLIS.defaultValue();
    private static final int HEARTBEAT_INTERVAL_MILLIS_DEFAULT = (Integer)MongoDBSourceOptions.HEARTBEAT_INTERVAL_MILLIS.defaultValue();
    private static final boolean SCAN_INCREMENTAL_SNAPSHOT_ENABLED_DEFAULT = (Boolean)MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED.defaultValue();
    private static final int SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB_DEFAULT = (Integer)MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB.defaultValue();
    private static final int SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SAMPLES_DEFAULT = (Integer)MongoDBSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SAMPLES.defaultValue();
    private static final int CHUNK_META_GROUP_SIZE_DEFAULT = (Integer)SourceOptions.CHUNK_META_GROUP_SIZE.defaultValue();
    private static final boolean SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED_DEFAULT = (Boolean)SourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED.defaultValue();
    private static final boolean FULL_DOCUMENT_PRE_POST_IMAGE_ENABLED_DEFAULT = (Boolean)MongoDBSourceOptions.FULL_DOCUMENT_PRE_POST_IMAGE.defaultValue();
    private static final boolean SCAN_NO_CURSOR_TIMEOUT_DEFAULT = (Boolean)MongoDBSourceOptions.SCAN_NO_CURSOR_TIMEOUT.defaultValue();
    private static final boolean SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP_DEFAULT = (Boolean)SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP.defaultValue();
    private static final boolean SCAN_NEWLY_ADDED_TABLE_ENABLED_DEFAULT = (Boolean)SourceOptions.SCAN_NEWLY_ADDED_TABLE_ENABLED.defaultValue();

    @Test
    public void testCommonProperties() {
        Map<String, String> properties = this.getAllOptions();
        DynamicTableSource actualSource = MongoDBTableFactoryTest.createTableSource(SCHEMA, properties);
        MongoDBTableSource expectedSource = new MongoDBTableSource(SCHEMA, (String)MongoDBSourceOptions.SCHEME.defaultValue(), MY_HOSTS, USER, PASSWORD, MY_DATABASE, MY_TABLE, null, StartupOptions.initial(), null, Integer.valueOf(BATCH_SIZE_DEFAULT), Integer.valueOf(POLL_MAX_BATCH_SIZE_DEFAULT), Integer.valueOf(POLL_AWAIT_TIME_MILLIS_DEFAULT), Integer.valueOf(HEARTBEAT_INTERVAL_MILLIS_DEFAULT), LOCAL_TIME_ZONE, SCAN_INCREMENTAL_SNAPSHOT_ENABLED_DEFAULT, Integer.valueOf(CHUNK_META_GROUP_SIZE_DEFAULT), Integer.valueOf(SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB_DEFAULT), Integer.valueOf(SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SAMPLES_DEFAULT), SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED_DEFAULT, FULL_DOCUMENT_PRE_POST_IMAGE_ENABLED_DEFAULT, SCAN_NO_CURSOR_TIMEOUT_DEFAULT, SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP_DEFAULT, SCAN_NEWLY_ADDED_TABLE_ENABLED_DEFAULT);
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testOptionalProperties() {
        Map<String, String> options = this.getAllOptions();
        options.put("scheme", "mongodb+srv");
        options.put("connection.options", "replicaSet=test&connectTimeoutMS=300000");
        options.put("scan.startup.mode", "timestamp");
        options.put("scan.startup.timestamp-millis", "1667232000000");
        options.put("initial.snapshotting.queue.size", "100");
        options.put("batch.size", "101");
        options.put("poll.max.batch.size", "102");
        options.put("poll.await.time.ms", "103");
        options.put("heartbeat.interval.ms", "104");
        options.put("scan.incremental.snapshot.enabled", "true");
        options.put("chunk-meta.group.size", "1001");
        options.put("scan.incremental.snapshot.chunk.size.mb", "10");
        options.put("scan.incremental.snapshot.chunk.samples", "10");
        options.put("scan.incremental.close-idle-reader.enabled", "true");
        options.put("scan.incremental.snapshot.backfill.skip", "true");
        options.put("scan.newly-added-table.enabled", "true");
        options.put("scan.full-changelog", "true");
        options.put("scan.cursor.no-timeout", "false");
        DynamicTableSource actualSource = MongoDBTableFactoryTest.createTableSource(SCHEMA, options);
        MongoDBTableSource expectedSource = new MongoDBTableSource(SCHEMA, "mongodb+srv", MY_HOSTS, USER, PASSWORD, MY_DATABASE, MY_TABLE, "replicaSet=test&connectTimeoutMS=300000", StartupOptions.timestamp((long)1667232000000L), Integer.valueOf(100), Integer.valueOf(101), Integer.valueOf(102), Integer.valueOf(103), Integer.valueOf(104), LOCAL_TIME_ZONE, true, Integer.valueOf(1001), Integer.valueOf(10), Integer.valueOf(10), true, true, false, true, true);
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
    }

    @Test
    public void testMetadataColumns() {
        Map<String, String> properties = this.getAllOptions();
        DynamicTableSource actualSource = MongoDBTableFactoryTest.createTableSource(SCHEMA_WITH_METADATA, properties);
        MongoDBTableSource mongoDBSource = (MongoDBTableSource)actualSource;
        mongoDBSource.applyReadableMetadata(Arrays.asList("op_ts", "database_name"), SCHEMA_WITH_METADATA.toSourceRowDataType());
        actualSource = mongoDBSource.copy();
        MongoDBTableSource expectedSource = new MongoDBTableSource(ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)SCHEMA_WITH_METADATA), (String)MongoDBSourceOptions.SCHEME.defaultValue(), MY_HOSTS, USER, PASSWORD, MY_DATABASE, MY_TABLE, null, StartupOptions.initial(), null, Integer.valueOf(BATCH_SIZE_DEFAULT), Integer.valueOf(POLL_MAX_BATCH_SIZE_DEFAULT), Integer.valueOf(POLL_AWAIT_TIME_MILLIS_DEFAULT), Integer.valueOf(HEARTBEAT_INTERVAL_MILLIS_DEFAULT), LOCAL_TIME_ZONE, SCAN_INCREMENTAL_SNAPSHOT_ENABLED_DEFAULT, Integer.valueOf(CHUNK_META_GROUP_SIZE_DEFAULT), Integer.valueOf(SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB_DEFAULT), Integer.valueOf(SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SAMPLES_DEFAULT), SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED_DEFAULT, FULL_DOCUMENT_PRE_POST_IMAGE_ENABLED_DEFAULT, SCAN_NO_CURSOR_TIMEOUT_DEFAULT, SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP_DEFAULT, SCAN_NEWLY_ADDED_TABLE_ENABLED_DEFAULT);
        expectedSource.producedDataType = SCHEMA_WITH_METADATA.toSourceRowDataType();
        expectedSource.metadataKeys = Arrays.asList("op_ts", "database_name");
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        ScanTableSource.ScanRuntimeProvider provider = mongoDBSource.getScanRuntimeProvider((ScanTableSource.ScanContext)ScanRuntimeProviderContext.INSTANCE);
        DebeziumSourceFunction debeziumSourceFunction = (DebeziumSourceFunction)((SourceFunctionProvider)provider).createSourceFunction();
        AssertUtils.assertProducedTypeOfSourceFunction((DebeziumSourceFunction)debeziumSourceFunction, (DataType)expectedSource.producedDataType);
    }

    @Test
    public void testValidation() {
        try {
            Map<String, String> properties = this.getAllOptions();
            properties.put("unknown", "abc");
            MongoDBTableFactoryTest.createTableSource(SCHEMA, properties);
            Assert.fail((String)"exception expected");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)t, (String)"Unsupported options:\n\nunknown").isPresent());
        }
    }

    private Map<String, String> getAllOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "mongodb-cdc");
        options.put("hosts", MY_HOSTS);
        options.put("username", USER);
        options.put("password", PASSWORD);
        options.put("database", MY_DATABASE);
        options.put("collection", MY_TABLE);
        return options;
    }

    private static DynamicTableSource createTableSource(ResolvedSchema schema, Map<String, String> options) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)ObjectIdentifier.of((String)"default", (String)"default", (String)"t1"), (ResolvedCatalogTable)new ResolvedCatalogTable(CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (String)"mock source", new ArrayList(), options), schema), (ReadableConfig)new Configuration(), (ClassLoader)MongoDBTableFactoryTest.class.getClassLoader(), (boolean)false);
    }
}

