/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.utils;

import org.apache.flink.cdc.connectors.mongodb.source.utils.ResumeTokenUtils;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class ResumeTokenUtilsTest {
    @Test
    public void testDecodeBinDataFormat() {
        BsonDocument resumeToken = BsonDocument.parse((String)"{\"_data\": {\"$binary\": {\"base64\": \"gmNXqzwAAAABRmRfaWQAZGNXqj41xq4H4ebHNwBaEATmzwG2DzpOl4tpOyYEG9zABA==\", \"subType\": \"00\"}}}");
        BsonTimestamp expected = new BsonTimestamp(1666689852, 1);
        BsonTimestamp actual = ResumeTokenUtils.decodeTimestamp((BsonDocument)resumeToken);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDecodeHexFormatV0() {
        BsonDocument resumeToken = BsonDocument.parse((String)" {\"_data\": \"826357B0840000000129295A1004461ECCED47A6420D9713A5135650360746645F696400646357B05F35C6AE07E1E6C7390004\"}");
        BsonTimestamp expected = new BsonTimestamp(1666691204, 1);
        BsonTimestamp actual = ResumeTokenUtils.decodeTimestamp((BsonDocument)resumeToken);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDecodeHexFormatV1() {
        BsonDocument resumeToken = BsonDocument.parse((String)"{\"_data\": \"82612E8513000000012B022C0100296E5A1004A5093ABB38FE4B9EA67F01BB1A96D812463C5F6964003C5F5F5F78000004\"}");
        BsonTimestamp expected = new BsonTimestamp(1630438675, 1);
        BsonTimestamp actual = ResumeTokenUtils.decodeTimestamp((BsonDocument)resumeToken);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

