/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source.utils;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.flink.cdc.connectors.mongodb.source.utils.BsonUtils;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonNull;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.junit.Test;

public class BsonUtilsTest {
    @Test
    public void testCompareBsonValue() {
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonDecimal128(Decimal128.parse((String)"18")), (BsonValue)new BsonDecimal128(Decimal128.parse((String)"17"))) > 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonDecimal128(Decimal128.parse((String)"17")), (BsonValue)new BsonDecimal128(Decimal128.parse((String)"17"))));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonDecimal128(Decimal128.parse((String)"16")), (BsonValue)new BsonDecimal128(Decimal128.parse((String)"17"))) < 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonString("apple"), (BsonValue)new BsonString("banana")) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonString("banana"), (BsonValue)new BsonString("banana")));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonString("cherry"), (BsonValue)new BsonString("banana")) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonArray(Arrays.asList(new BsonString("fruit"), new BsonString("apple"))), (BsonValue)new BsonArray(Arrays.asList(new BsonString("fruit"), new BsonString("banana")))) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonArray(Arrays.asList(new BsonString("fruit"), new BsonString("banana"))), (BsonValue)new BsonArray(Arrays.asList(new BsonString("fruit"), new BsonString("banana")))));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonArray(Arrays.asList(new BsonString("fruit"), new BsonString("cherry"))), (BsonValue)new BsonArray(Arrays.asList(new BsonString("fruit"), new BsonString("banana")))) > 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonArray(Arrays.asList(new BsonString("apple"), new BsonString("cherry"))), (BsonValue)new BsonArray(Arrays.asList(new BsonString("apple"), new BsonString("banana")))));
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonArray(Arrays.asList(new BsonString("apple"), new BsonString("banana"))), (BsonValue)new BsonArray(Arrays.asList(new BsonString("banana"), new BsonString("apple")))));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonArray(Arrays.asList(new BsonString("cherry"), new BsonString("apple"))), (BsonValue)new BsonArray(Arrays.asList(new BsonString("cherry"), new BsonString("banana")))) < 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonBinary("apple".getBytes()), (BsonValue)new BsonBinary("banana".getBytes())) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonBinary("banana".getBytes()), (BsonValue)new BsonBinary("banana".getBytes())));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonBinary("cherry".getBytes()), (BsonValue)new BsonBinary("banana".getBytes())) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonBoolean(false), (BsonValue)new BsonBoolean(true)) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonBoolean(true), (BsonValue)new BsonBoolean(true)));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonBoolean(true), (BsonValue)new BsonBoolean(false)) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonDateTime(1600000000L), (BsonValue)new BsonDateTime(1700000000L)) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonDateTime(1700000000L), (BsonValue)new BsonDateTime(1700000000L)));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonDateTime(1800000000L), (BsonValue)new BsonDateTime(1700000000L)) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonDocument("fruit", (BsonValue)new BsonString("apple")), (BsonValue)new BsonDocument("fruit", (BsonValue)new BsonString("banana"))) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonDocument("fruit", (BsonValue)new BsonString("banana")), (BsonValue)new BsonDocument("fruit", (BsonValue)new BsonString("banana"))));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonDocument("fruit", (BsonValue)new BsonString("cherry")), (BsonValue)new BsonDocument("fruit", (BsonValue)new BsonString("banana"))) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonTimestamp(1600000000L), (BsonValue)new BsonTimestamp(1700000000L)) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonTimestamp(1700000000L), (BsonValue)new BsonTimestamp(1700000000L)));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonTimestamp(1800000000L), (BsonValue)new BsonTimestamp(1700000000L)) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonRegularExpression("[a-xA-X]"), (BsonValue)new BsonRegularExpression("[b-yB-Y]")) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonRegularExpression("[b-yB-Y]"), (BsonValue)new BsonRegularExpression("[b-yB-Y]")));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonRegularExpression("[c-zC-Z]"), (BsonValue)new BsonRegularExpression("[b-yB-Y]")) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonJavaScriptWithScope("console.log('apple');", new BsonDocument()), (BsonValue)new BsonJavaScriptWithScope("console.log('banana');", new BsonDocument())) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonJavaScriptWithScope("console.log('banana');", new BsonDocument()), (BsonValue)new BsonJavaScriptWithScope("console.log('banana');", new BsonDocument())));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonJavaScriptWithScope("console.log('cherry');", new BsonDocument()), (BsonValue)new BsonJavaScriptWithScope("console.log('banana');", new BsonDocument())) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonJavaScriptWithScope("console.log('apple');", new BsonDocument("_id", (BsonValue)new BsonString("apple"))), (BsonValue)new BsonJavaScriptWithScope("console.log('apple');", new BsonDocument("_id", (BsonValue)new BsonString("banana")))) < 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonJavaScriptWithScope("console.log('apple');", new BsonDocument("_id", (BsonValue)new BsonString("banana"))), (BsonValue)new BsonJavaScriptWithScope("console.log('apple');", new BsonDocument("_id", (BsonValue)new BsonString("banana")))));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonJavaScriptWithScope("console.log('apple');", new BsonDocument("_id", (BsonValue)new BsonString("cherry"))), (BsonValue)new BsonJavaScriptWithScope("console.log('apple');", new BsonDocument("_id", (BsonValue)new BsonString("banana")))) > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonNull(), (BsonValue)new BsonString("")) < 0 ? 1 : 0) != 0);
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonBoolean(true), (BsonValue)new BsonString("")) > 0 ? 1 : 0) != 0);
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonNull(), (BsonValue)new BsonNull()));
        TestCase.assertEquals((int)0, (int)BsonUtils.compareBsonValue((BsonValue)new BsonUndefined(), (BsonValue)new BsonUndefined()));
        TestCase.assertTrue((BsonUtils.compareBsonValue((BsonValue)new BsonUndefined(), (BsonValue)new BsonNull()) < 0 ? 1 : 0) != 0);
    }
}

