/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb.source;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.flink.cdc.connectors.mongodb.utils.MongoDBContainer;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startables;

public class MongoDBSourceTestBase {
    protected static MongoClient mongodbClient;
    protected static final int DEFAULT_PARALLELISM = 4;
    @Rule
    public final MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).setRpcServiceSharing(RpcServiceSharing.DEDICATED).withHaLeadershipControl().build());
    private static final Logger LOG;
    @ClassRule
    public static final MongoDBContainer CONTAINER;

    @BeforeClass
    public static void startContainers() {
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(CONTAINER)).join();
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(CONTAINER.getConnectionString())).build();
        mongodbClient = MongoClients.create((MongoClientSettings)settings);
        LOG.info("Containers are started.");
    }

    static {
        LOG = LoggerFactory.getLogger(MongoDBSourceTestBase.class);
        CONTAINER = new MongoDBContainer("mongo:6.0.9").withSharding().withLogConsumer((Consumer<OutputFrame>)new Slf4jLogConsumer(LOG));
    }
}

