/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.flink.cdc.connectors.mongodb.LegacyMongoDBContainer;
import org.apache.flink.test.util.AbstractTestBase;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startables;

public class LegacyMongoDBTestBase
extends AbstractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyMongoDBTestBase.class);
    @ClassRule
    public static final Network NETWORK = Network.newNetwork();
    protected static final LegacyMongoDBContainer MONGODB_CONTAINER = (LegacyMongoDBContainer)new LegacyMongoDBContainer(NETWORK).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    protected static MongoClient mongodbClient;

    @BeforeClass
    public static void startContainers() {
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(MONGODB_CONTAINER)).join();
        LegacyMongoDBTestBase.initialClient();
        LOG.info("Containers are started.");
    }

    private static void initialClient() {
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(MONGODB_CONTAINER.getConnectionString("superuser", "superpw"))).build();
        mongodbClient = MongoClients.create((MongoClientSettings)settings);
    }

    protected static MongoDatabase getMongoDatabase(String dbName) {
        return mongodbClient.getDatabase(dbName);
    }
}

