/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.flink.cdc.connectors.mongodb.LegacyMongoDBContainer;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;

public abstract class LegacyMongoDBSourceTestBase
extends TestLogger {
    protected static final Logger LOG = LoggerFactory.getLogger(LegacyMongoDBSourceTestBase.class);
    protected static final int DEFAULT_PARALLELISM = 4;
    @Rule
    public final MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).setRpcServiceSharing(RpcServiceSharing.DEDICATED).withHaLeadershipControl().build());
    @ClassRule
    public static final Network NETWORK = Network.newNetwork();
    @ClassRule
    public static final LegacyMongoDBContainer CONFIG = (LegacyMongoDBContainer)new LegacyMongoDBContainer(NETWORK, LegacyMongoDBContainer.ShardingClusterRole.CONFIG).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    @ClassRule
    public static final LegacyMongoDBContainer SHARD = (LegacyMongoDBContainer)((LegacyMongoDBContainer)new LegacyMongoDBContainer(NETWORK, LegacyMongoDBContainer.ShardingClusterRole.SHARD).dependsOn(new Startable[]{CONFIG})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    @ClassRule
    public static final LegacyMongoDBContainer ROUTER = (LegacyMongoDBContainer)((LegacyMongoDBContainer)new LegacyMongoDBContainer(NETWORK, LegacyMongoDBContainer.ShardingClusterRole.ROUTER).dependsOn(new Startable[]{SHARD})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
    protected static MongoClient mongodbClient;

    @BeforeClass
    public static void startContainers() {
        LOG.info("Starting containers...");
        Startables.deepStart(Stream.of(CONFIG)).join();
        Startables.deepStart(Stream.of(SHARD)).join();
        Startables.deepStart(Stream.of(ROUTER)).join();
        LegacyMongoDBSourceTestBase.initialClient();
        LOG.info("Containers are started.");
    }

    @AfterClass
    public static void closeContainers() {
        if (mongodbClient != null) {
            mongodbClient.close();
        }
        if (ROUTER != null) {
            ROUTER.close();
        }
        if (SHARD != null) {
            SHARD.close();
        }
        if (CONFIG != null) {
            CONFIG.close();
        }
    }

    private static void initialClient() {
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(ROUTER.getConnectionString("superuser", "superpw"))).build();
        mongodbClient = MongoClients.create((MongoClientSettings)settings);
    }
}

