/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mongodb;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public class LegacyMongoDBContainer
extends GenericContainer<LegacyMongoDBContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyMongoDBContainer.class);
    private static final String DOCKER_IMAGE_NAME = "mongo:5.0.2";
    public static final int MONGODB_PORT = 27017;
    public static final String MONGO_SUPER_USER = "superuser";
    public static final String MONGO_SUPER_PASSWORD = "superpw";
    public static final String FLINK_USER = "flinkuser";
    public static final String FLINK_USER_PASSWORD = "a1?~!@#$%^&*(){}[]<>.,+_-=/|:;";
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(.*)//.*$");
    private final ShardingClusterRole clusterRole;

    public LegacyMongoDBContainer(Network network) {
        this(network, ShardingClusterRole.NONE);
    }

    public LegacyMongoDBContainer(Network network, ShardingClusterRole clusterRole) {
        super((Future)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromClasspath("random.key", "docker/mongodb/random.key")).withFileFromClasspath("setup.js", "docker/mongodb/setup.js")).withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(DOCKER_IMAGE_NAME)).copy("setup.js", "/docker-entrypoint-initdb.d/setup.js")).copy("random.key", "/data/keyfile/random.key")).run("chown mongodb /data/keyfile/random.key")).run("chmod 400 /data/keyfile/random.key")).env("MONGO_INITDB_ROOT_USERNAME", MONGO_SUPER_USER)).env("MONGO_INITDB_ROOT_PASSWORD", MONGO_SUPER_PASSWORD)).env("MONGO_INITDB_DATABASE", "admin")).build()));
        this.clusterRole = clusterRole;
        this.withNetwork(network);
        this.withNetworkAliases(new String[]{clusterRole.hostname});
        this.withExposedPorts(new Integer[]{27017});
        this.withCommand(ShardingClusterRole.startupCommand(clusterRole));
        this.waitingFor(clusterRole.waitStrategy);
    }

    public String getConnectionString(String username, String password) {
        return String.format("mongodb://%s:%s@%s:%d", username, password, this.getContainerIpAddress(), this.getMappedPort(27017));
    }

    public String getHostAndPort() {
        return String.format("%s:%s", this.getContainerIpAddress(), this.getMappedPort(27017));
    }

    public void executeCommand(String command) {
        try {
            LOG.info("Executing mongo command: {}", (Object)command);
            Container.ExecResult execResult = this.execInContainer(new String[]{"mongo", "-u", MONGO_SUPER_USER, "-p", MONGO_SUPER_PASSWORD, "--eval", command});
            LOG.info(execResult.getStdout());
            if (execResult.getExitCode() != 0) {
                throw new IllegalStateException("Execute mongo command failed " + execResult.getStdout());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Execute mongo command failed", e);
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        LOG.info("Preparing a MongoDB Container with sharding cluster role {}...", (Object)this.clusterRole);
        if (this.clusterRole != ShardingClusterRole.ROUTER) {
            this.initReplicaSet();
        } else {
            this.initShard();
        }
    }

    protected void initReplicaSet() {
        LOG.info("Initializing a single node replica set...");
        this.executeCommand(String.format("rs.initiate({ _id : '%s', configsvr: %s, members: [{ _id: 0, host: '%s:%d'}]})", this.clusterRole.replicaSetName, this.clusterRole == ShardingClusterRole.CONFIG, this.clusterRole.hostname, 27017));
        LOG.info("Waiting for single node replica set initialized...");
        this.executeCommand(String.format("var attempt = 0; while(%s) { if (attempt > %d) {quit(1);} print('%s ' + attempt); sleep(100);  attempt++;  }", "db.runCommand( { isMaster: 1 } ).ismaster==false", 60, "An attempt to await for a single node replica set initialization:"));
    }

    protected void initShard() {
        LOG.info("Initializing a sharded cluster...");
        this.executeCommand("db.getSiblingDB('config').settings.updateOne(\n   { _id: \"chunksize\" },\n   { $set: { _id: \"chunksize\", value: 1 } },\n   { upsert: true }\n);");
        this.executeCommand(String.format("sh.addShard('%s/%s:%d')", ShardingClusterRole.SHARD.replicaSetName, ShardingClusterRole.SHARD.hostname, 27017));
    }

    public String executeCommandFileInSeparateDatabase(String fileNameIgnoreSuffix) {
        return this.executeCommandFileInDatabase(fileNameIgnoreSuffix, fileNameIgnoreSuffix + "_" + Integer.toUnsignedString(new Random().nextInt(), 36));
    }

    public String executeCommandFileInDatabase(String fileNameIgnoreSuffix, String databaseName) {
        String dbName = databaseName != null ? databaseName : fileNameIgnoreSuffix;
        String ddlFile = String.format("ddl/%s.js", fileNameIgnoreSuffix);
        URL ddlTestFile = LegacyMongoDBContainer.class.getClassLoader().getResource(ddlFile);
        Assert.assertNotNull((String)("Cannot locate " + ddlFile), (Object)ddlTestFile);
        try {
            String command0 = String.format("db = db.getSiblingDB('%s');\n", dbName);
            String command1 = Files.readAllLines(Paths.get(ddlTestFile.toURI())).stream().filter(x -> StringUtils.isNotBlank((CharSequence)x) && !x.trim().startsWith("//")).map(x -> {
                Matcher m = COMMENT_PATTERN.matcher((CharSequence)x);
                return m.matches() ? m.group(1) : x;
            }).collect(Collectors.joining("\n"));
            this.executeCommand(command0 + command1);
            return dbName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ShardingClusterRole {
        CONFIG("config0", "rs0-config", (WaitStrategy)Wait.forLogMessage((String)".*[Ww]aiting for connections.*", (int)2)),
        SHARD("shard0", "rs0-shard", (WaitStrategy)Wait.forLogMessage((String)".*[Ww]aiting for connections.*", (int)2)),
        ROUTER("router0", null, (WaitStrategy)Wait.forLogMessage((String)".*[Ww]aiting for connections.*", (int)1)),
        NONE("mongo0", "rs0", (WaitStrategy)Wait.forLogMessage((String)".*Replication has not yet been configured.*", (int)1));

        private final String hostname;
        private final String replicaSetName;
        private final WaitStrategy waitStrategy;

        private ShardingClusterRole(String hostname, String replicaSetName, WaitStrategy waitStrategy) {
            this.hostname = hostname;
            this.replicaSetName = replicaSetName;
            this.waitStrategy = waitStrategy;
        }

        public static String startupCommand(ShardingClusterRole clusterRole) {
            switch (clusterRole) {
                case CONFIG: {
                    return String.format("mongod --configsvr --port %d --replSet %s --keyFile /data/keyfile/random.key", 27017, clusterRole.replicaSetName);
                }
                case SHARD: {
                    return String.format("mongod --shardsvr --port %d --replSet %s --keyFile /data/keyfile/random.key", 27017, clusterRole.replicaSetName);
                }
                case ROUTER: {
                    return String.format("mongos --configdb %s/%s:%d --bind_ip_all --keyFile /data/keyfile/random.key", ShardingClusterRole.CONFIG.replicaSetName, ShardingClusterRole.CONFIG.hostname, 27017);
                }
            }
            return String.format("mongod --port %d --replSet %s --keyFile /data/keyfile/random.key", 27017, ShardingClusterRole.NONE.replicaSetName);
        }
    }
}

