/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.source.enumerator.AssignmentStatus;
import org.apache.flink.connector.kafka.source.enumerator.TopicPartitionAndAssignmentStatus;
import org.apache.kafka.common.TopicPartition;

@Internal
public class KafkaSourceEnumState {
    private final Set<TopicPartitionAndAssignmentStatus> partitions;
    private final boolean initialDiscoveryFinished;

    public KafkaSourceEnumState(Set<TopicPartitionAndAssignmentStatus> partitions, boolean initialDiscoveryFinished) {
        this.partitions = partitions;
        this.initialDiscoveryFinished = initialDiscoveryFinished;
    }

    public KafkaSourceEnumState(Set<TopicPartition> assignPartitions, Set<TopicPartition> unassignedInitialPartitions, boolean initialDiscoveryFinished) {
        this.partitions = new HashSet<TopicPartitionAndAssignmentStatus>();
        this.partitions.addAll(assignPartitions.stream().map(topicPartition -> new TopicPartitionAndAssignmentStatus((TopicPartition)topicPartition, AssignmentStatus.ASSIGNED)).collect(Collectors.toSet()));
        this.partitions.addAll(unassignedInitialPartitions.stream().map(topicPartition -> new TopicPartitionAndAssignmentStatus((TopicPartition)topicPartition, AssignmentStatus.UNASSIGNED_INITIAL)).collect(Collectors.toSet()));
        this.initialDiscoveryFinished = initialDiscoveryFinished;
    }

    public Set<TopicPartitionAndAssignmentStatus> partitions() {
        return this.partitions;
    }

    public Set<TopicPartition> assignedPartitions() {
        return this.filterPartitionsByAssignmentStatus(AssignmentStatus.ASSIGNED);
    }

    public Set<TopicPartition> unassignedInitialPartitions() {
        return this.filterPartitionsByAssignmentStatus(AssignmentStatus.UNASSIGNED_INITIAL);
    }

    public boolean initialDiscoveryFinished() {
        return this.initialDiscoveryFinished;
    }

    private Set<TopicPartition> filterPartitionsByAssignmentStatus(AssignmentStatus assignmentStatus) {
        return this.partitions.stream().filter(partitionWithStatus -> partitionWithStatus.assignmentStatus().equals((Object)assignmentStatus)).map(TopicPartitionAndAssignmentStatus::topicPartition).collect(Collectors.toSet());
    }
}

