/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import java.util.Collection;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.sink.internal.FlinkKafkaInternalProducer;
import org.apache.flink.connector.kafka.sink.internal.ProducerPool;
import org.apache.flink.connector.kafka.sink.internal.TransactionNamingStrategyImpl;
import org.apache.flink.connector.kafka.sink.internal.TransactionalIdFactory;
import org.apache.flink.util.Preconditions;

@Internal
public class TransactionNamingStrategyContextImpl
implements TransactionNamingStrategyImpl.Context {
    private final String transactionalIdPrefix;
    private final int subtaskId;
    private Set<String> ongoingTransactions;
    private final ProducerPool producerPool;
    private long lastCheckpointId;
    private long nextCheckpointId;

    public TransactionNamingStrategyContextImpl(String transactionalIdPrefix, int subtaskId, long lastCheckpointId, ProducerPool producerPool) {
        this.transactionalIdPrefix = (String)Preconditions.checkNotNull((Object)transactionalIdPrefix, (String)"transactionalIdPrefix must not be null");
        this.subtaskId = subtaskId;
        this.producerPool = (ProducerPool)Preconditions.checkNotNull((Object)producerPool, (String)"producerPool must not be null");
        this.lastCheckpointId = lastCheckpointId;
    }

    @Override
    public String buildTransactionalId(long offset) {
        return TransactionalIdFactory.buildTransactionalId(this.transactionalIdPrefix, this.subtaskId, offset);
    }

    @Override
    public long getNextCheckpointId() {
        return this.nextCheckpointId;
    }

    public void setNextCheckpointId(long nextCheckpointId) {
        this.nextCheckpointId = nextCheckpointId;
    }

    public void setLastCheckpointId(long lastCheckpointId) {
        this.lastCheckpointId = lastCheckpointId;
    }

    @Override
    public Set<String> getOngoingTransactions() {
        return this.ongoingTransactions;
    }

    public void setOngoingTransactions(Collection<String> ongoingTransactions) {
        this.ongoingTransactions = Set.copyOf(ongoingTransactions);
    }

    @Override
    public long getLastCheckpointId() {
        return this.lastCheckpointId;
    }

    @Override
    public FlinkKafkaInternalProducer<byte[], byte[]> getProducer(String transactionalId) {
        return this.producerPool.getTransactionalProducer(transactionalId, this.nextCheckpointId);
    }

    @Override
    public void recycle(FlinkKafkaInternalProducer<byte[], byte[]> producer) {
        this.producerPool.recycle(producer);
    }
}

