/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.connector.kafka.lineage.DefaultKafkaDatasetIdentifier;
import org.apache.flink.connector.kafka.lineage.KafkaDatasetIdentifierProvider;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriberUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicPatternSubscriber
implements KafkaSubscriber,
KafkaDatasetIdentifierProvider {
    private static final long serialVersionUID = -7471048577725467797L;
    private static final Logger LOG = LoggerFactory.getLogger(TopicPatternSubscriber.class);
    private final Pattern topicPattern;

    TopicPatternSubscriber(Pattern topicPattern) {
        this.topicPattern = topicPattern;
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(AdminClient adminClient) {
        LOG.debug("Fetching descriptions for {} topics on Kafka cluster", (Object)this.topicPattern.pattern());
        Map<String, TopicDescription> matchedTopicMetadata = KafkaSubscriberUtils.getTopicMetadata(adminClient, this.topicPattern);
        HashSet<TopicPartition> subscribedTopicPartitions = new HashSet<TopicPartition>();
        matchedTopicMetadata.forEach((topicName, topicDescription) -> {
            for (TopicPartitionInfo partition : topicDescription.partitions()) {
                subscribedTopicPartitions.add(new TopicPartition(topicDescription.name(), partition.partition()));
            }
        });
        return subscribedTopicPartitions;
    }

    @Override
    public Optional<DefaultKafkaDatasetIdentifier> getDatasetIdentifier() {
        return Optional.of(DefaultKafkaDatasetIdentifier.ofPattern(this.topicPattern));
    }
}

