/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.testutils;

import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.connector.kafka.testutils.DynamicKafkaSourceExternalContext;
import org.apache.flink.connector.testframe.external.ExternalContextFactory;
import org.testcontainers.containers.KafkaContainer;

public class DynamicKafkaSourceExternalContextFactory
implements ExternalContextFactory<DynamicKafkaSourceExternalContext> {
    private final KafkaContainer kafkaContainer0;
    private final KafkaContainer kafkaContainer1;
    private final List<URL> connectorJars;

    public DynamicKafkaSourceExternalContextFactory(KafkaContainer kafkaContainer0, KafkaContainer kafkaContainer1, List<URL> connectorJars) {
        this.kafkaContainer0 = kafkaContainer0;
        this.kafkaContainer1 = kafkaContainer1;
        this.connectorJars = connectorJars;
    }

    public DynamicKafkaSourceExternalContext createExternalContext(String testName) {
        return new DynamicKafkaSourceExternalContext((List<String>)ImmutableList.of((Object)DynamicKafkaSourceExternalContextFactory.getBootstrapServers(this.kafkaContainer0), (Object)DynamicKafkaSourceExternalContextFactory.getBootstrapServers(this.kafkaContainer1)), this.connectorJars);
    }

    private static String getBootstrapServers(KafkaContainer kafkaContainer) {
        String internalEndpoints = kafkaContainer.getNetworkAliases().stream().map(host -> String.join((CharSequence)":", host, Integer.toString(9092))).collect(Collectors.joining(","));
        return String.join((CharSequence)",", kafkaContainer.getBootstrapServers(), internalEndpoints);
    }
}

