/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaPartitioner;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.clients.producer.ProducerRecord;

@Internal
class DynamicKafkaRecordSerializationSchema
implements KafkaRecordSerializationSchema<RowData> {
    private final Set<String> topics;
    private final Pattern topicPattern;
    private final KafkaPartitioner<RowData> partitioner;
    @Nullable
    private final SerializationSchema<RowData> keySerialization;
    private final SerializationSchema<RowData> valueSerialization;
    private final RowData.FieldGetter[] keyFieldGetters;
    private final RowData.FieldGetter[] valueFieldGetters;
    private final boolean hasMetadata;
    private final int[] metadataPositions;
    private final boolean upsertMode;
    private final Map<String, Boolean> topicPatternMatches;

    DynamicKafkaRecordSerializationSchema(@Nullable List<String> topics, @Nullable Pattern topicPattern, @Nullable KafkaPartitioner<RowData> partitioner, @Nullable SerializationSchema<RowData> keySerialization, SerializationSchema<RowData> valueSerialization, RowData.FieldGetter[] keyFieldGetters, RowData.FieldGetter[] valueFieldGetters, boolean hasMetadata, int[] metadataPositions, boolean upsertMode) {
        if (upsertMode) {
            Preconditions.checkArgument((keySerialization != null && keyFieldGetters.length > 0 ? 1 : 0) != 0, (Object)"Key must be set in upsert mode for serialization schema.");
        }
        Preconditions.checkArgument((topics != null && topicPattern == null && topics.size() > 0 || topics == null && topicPattern != null ? 1 : 0) != 0, (Object)"Either Topic or Topic Pattern must be set.");
        this.topics = topics != null ? new HashSet<String>(topics) : null;
        this.topicPattern = topicPattern;
        this.partitioner = partitioner;
        this.keySerialization = keySerialization;
        this.valueSerialization = (SerializationSchema)Preconditions.checkNotNull(valueSerialization);
        this.keyFieldGetters = keyFieldGetters;
        this.valueFieldGetters = valueFieldGetters;
        this.hasMetadata = hasMetadata;
        this.metadataPositions = metadataPositions;
        this.upsertMode = upsertMode;
        this.topicPatternMatches = new HashMap<String, Boolean>();
    }

    @Override
    public ProducerRecord<byte[], byte[]> serialize(RowData consumedRow, KafkaRecordSerializationSchema.KafkaSinkContext context, Long timestamp) {
        RowData valueRow;
        byte[] valueSerialized;
        byte[] keySerialized;
        if (this.keySerialization == null && !this.hasMetadata) {
            byte[] valueSerialized2 = this.valueSerialization.serialize((Object)consumedRow);
            String targetTopic = this.getTargetTopic(consumedRow);
            return new ProducerRecord(targetTopic, this.extractPartition(consumedRow, targetTopic, null, valueSerialized2, context.getPartitionsForTopic(targetTopic)), null, (Object)valueSerialized2);
        }
        if (this.keySerialization == null) {
            keySerialized = null;
        } else {
            RowData keyRow = DynamicKafkaRecordSerializationSchema.createProjectedRow(consumedRow, RowKind.INSERT, this.keyFieldGetters);
            keySerialized = this.keySerialization.serialize((Object)keyRow);
        }
        RowKind kind = consumedRow.getRowKind();
        if (this.upsertMode) {
            if (kind == RowKind.DELETE || kind == RowKind.UPDATE_BEFORE) {
                valueSerialized = null;
            } else {
                valueRow = DynamicKafkaRecordSerializationSchema.createProjectedRow(consumedRow, kind, this.valueFieldGetters);
                valueRow.setRowKind(RowKind.INSERT);
                valueSerialized = this.valueSerialization.serialize((Object)valueRow);
            }
        } else {
            valueRow = DynamicKafkaRecordSerializationSchema.createProjectedRow(consumedRow, kind, this.valueFieldGetters);
            valueSerialized = this.valueSerialization.serialize((Object)valueRow);
        }
        String targetTopic = this.getTargetTopic(consumedRow);
        return new ProducerRecord(targetTopic, this.extractPartition(consumedRow, targetTopic, keySerialized, valueSerialized, context.getPartitionsForTopic(targetTopic)), (Long)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.TIMESTAMP), (Object)keySerialized, (Object)valueSerialized, (Iterable)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.HEADERS));
    }

    @Override
    public void open(SerializationSchema.InitializationContext context, KafkaRecordSerializationSchema.KafkaSinkContext sinkContext) throws Exception {
        if (this.keySerialization != null) {
            this.keySerialization.open(context);
        }
        if (this.partitioner != null) {
            this.partitioner.open(sinkContext.getParallelInstanceId(), sinkContext.getNumberOfParallelInstances());
        }
        this.valueSerialization.open(context);
    }

    private String getTargetTopic(RowData element) {
        if (this.topics != null && this.topics.size() == 1) {
            return (String)this.topics.stream().findFirst().get();
        }
        String targetTopic = (String)this.readMetadata(element, KafkaDynamicSink.WritableMetadata.TOPIC);
        if (targetTopic == null) {
            throw new IllegalArgumentException("The topic of the sink record is not valid. Expected a single topic but no topic is set.");
        }
        if (this.topics != null && !this.topics.contains(targetTopic)) {
            throw new IllegalArgumentException(String.format("The topic of the sink record is not valid. Expected topic to be in: %s but was: %s", this.topics, targetTopic));
        }
        if (this.topicPattern != null && !this.cachedTopicPatternMatch(targetTopic)) {
            throw new IllegalArgumentException(String.format("The topic of the sink record is not valid. Expected topic to match: %s but was: %s", this.topicPattern, targetTopic));
        }
        return targetTopic;
    }

    private boolean cachedTopicPatternMatch(String topic) {
        return this.topicPatternMatches.computeIfAbsent(topic, t -> this.topicPattern.matcher((CharSequence)t).matches());
    }

    private Integer extractPartition(RowData consumedRow, String targetTopic, @Nullable byte[] keySerialized, byte[] valueSerialized, int[] partitions) {
        if (this.partitioner != null) {
            return this.partitioner.partition(consumedRow, keySerialized, valueSerialized, targetTopic, partitions);
        }
        return null;
    }

    static RowData createProjectedRow(RowData consumedRow, RowKind kind, RowData.FieldGetter[] fieldGetters) {
        int arity = fieldGetters.length;
        GenericRowData genericRowData = new GenericRowData(kind, arity);
        for (int fieldPos = 0; fieldPos < arity; ++fieldPos) {
            genericRowData.setField(fieldPos, fieldGetters[fieldPos].getFieldOrNull(consumedRow));
        }
        return genericRowData;
    }

    private <T> T readMetadata(RowData consumedRow, KafkaDynamicSink.WritableMetadata metadata) {
        int pos = this.metadataPositions[metadata.ordinal()];
        if (pos < 0) {
            return null;
        }
        return (T)metadata.converter.read(consumedRow, pos);
    }
}

