/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.testutils;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;

public final class MockPartitionOffsetsRetriever
implements OffsetsInitializer.PartitionOffsetsRetriever {
    public static final OffsetsRetriever UNSUPPORTED_RETRIEVAL = partitions -> {
        throw new UnsupportedOperationException("The method was not supposed to be called");
    };
    private final OffsetsRetriever committedOffsets;
    private final OffsetsRetriever endOffsets;
    private final OffsetsRetriever beginningOffsets;
    private final TimestampOffsetsRetriever offsetsForTimes;

    public static MockPartitionOffsetsRetriever noInteractions() {
        return new MockPartitionOffsetsRetriever(UNSUPPORTED_RETRIEVAL, UNSUPPORTED_RETRIEVAL, UNSUPPORTED_RETRIEVAL, partitions -> {
            throw new UnsupportedOperationException("The method was not supposed to be called");
        });
    }

    public static MockPartitionOffsetsRetriever timestampAndEnd(TimestampOffsetsRetriever retriever, OffsetsRetriever endOffsets) {
        return new MockPartitionOffsetsRetriever(UNSUPPORTED_RETRIEVAL, endOffsets, UNSUPPORTED_RETRIEVAL, retriever);
    }

    public static MockPartitionOffsetsRetriever latest(OffsetsRetriever endOffsets) {
        return new MockPartitionOffsetsRetriever(UNSUPPORTED_RETRIEVAL, endOffsets, UNSUPPORTED_RETRIEVAL, partitions -> {
            throw new UnsupportedOperationException("The method was not supposed to be called");
        });
    }

    private MockPartitionOffsetsRetriever(OffsetsRetriever committedOffsets, OffsetsRetriever endOffsets, OffsetsRetriever beginningOffsets, TimestampOffsetsRetriever offsetsForTimes) {
        this.committedOffsets = committedOffsets;
        this.endOffsets = endOffsets;
        this.beginningOffsets = beginningOffsets;
        this.offsetsForTimes = offsetsForTimes;
    }

    public Map<TopicPartition, Long> committedOffsets(Collection<TopicPartition> partitions) {
        return (Map)this.committedOffsets.apply(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return (Map)this.endOffsets.apply(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return (Map)this.beginningOffsets.apply(partitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return (Map)this.offsetsForTimes.apply(timestampsToSearch);
    }

    public static interface TimestampOffsetsRetriever
    extends Function<Map<TopicPartition, Long>, Map<TopicPartition, OffsetAndTimestamp>> {
    }

    public static interface OffsetsRetriever
    extends Function<Collection<TopicPartition>, Map<TopicPartition, Long>> {
    }
}

