/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.connector.kafka.source.KafkaSourceBuilder;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.KafkaSerializationSchema;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaDeserializationSchemaWrapper;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchema;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public abstract class KafkaTestEnvironment {
    protected static final String KAFKA_HOST = "localhost";

    public static Config createConfig() {
        return new Config();
    }

    public abstract void prepare(Config var1) throws Exception;

    public void shutdown() throws Exception {
    }

    public abstract void deleteTestTopic(String var1);

    public abstract void createTestTopic(String var1, int var2, int var3, Properties var4);

    public void createTestTopic(String topic, int numberOfPartitions, int replicationFactor) {
        this.createTestTopic(topic, numberOfPartitions, replicationFactor, new Properties());
    }

    public abstract Properties getStandardProperties();

    public abstract Properties getSecureProperties();

    public abstract String getBrokerConnectionString();

    public abstract String getVersion();

    public Properties getIdempotentProducerConfig() {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("acks", "all");
        props.put("retries", "3");
        return props;
    }

    public <T> FlinkKafkaConsumerBase<T> getConsumer(List<String> topics, DeserializationSchema<T> deserializationSchema, Properties props) {
        return this.getConsumer(topics, (KafkaDeserializationSchema<T>)new KafkaDeserializationSchemaWrapper(deserializationSchema), props);
    }

    public <T> FlinkKafkaConsumerBase<T> getConsumer(String topic, KafkaDeserializationSchema<T> readSchema, Properties props) {
        return this.getConsumer(Collections.singletonList(topic), readSchema, props);
    }

    public <T> FlinkKafkaConsumerBase<T> getConsumer(String topic, DeserializationSchema<T> deserializationSchema, Properties props) {
        return this.getConsumer(Collections.singletonList(topic), deserializationSchema, props);
    }

    public abstract <T> FlinkKafkaConsumerBase<T> getConsumer(List<String> var1, KafkaDeserializationSchema<T> var2, Properties var3);

    public <T> KafkaSourceBuilder<T> getSourceBuilder(List<String> topics, DeserializationSchema<T> deserializationSchema, Properties props) {
        return this.getSourceBuilder(topics, (KafkaDeserializationSchema<T>)new KafkaDeserializationSchemaWrapper(deserializationSchema), props);
    }

    public <T> KafkaSourceBuilder<T> getSourceBuilder(String topic, KafkaDeserializationSchema<T> readSchema, Properties props) {
        return this.getSourceBuilder(Collections.singletonList(topic), readSchema, props);
    }

    public <T> KafkaSourceBuilder<T> getSourceBuilder(String topic, DeserializationSchema<T> deserializationSchema, Properties props) {
        return this.getSourceBuilder(Collections.singletonList(topic), deserializationSchema, props);
    }

    public abstract <T> KafkaSourceBuilder<T> getSourceBuilder(List<String> var1, KafkaDeserializationSchema<T> var2, Properties var3);

    public abstract <K, V> Collection<ConsumerRecord<K, V>> getAllRecordsFromTopic(Properties var1, String var2);

    public abstract <T> StreamSink<T> getProducerSink(String var1, SerializationSchema<T> var2, Properties var3, FlinkKafkaPartitioner<T> var4);

    @Deprecated
    public abstract <T> DataStreamSink<T> produceIntoKafka(DataStream<T> var1, String var2, KeyedSerializationSchema<T> var3, Properties var4, FlinkKafkaPartitioner<T> var5);

    public abstract <T> DataStreamSink<T> produceIntoKafka(DataStream<T> var1, String var2, SerializationSchema<T> var3, Properties var4, FlinkKafkaPartitioner<T> var5);

    public <T> DataStreamSink<T> produceIntoKafka(DataStream<T> stream, String topic, KafkaSerializationSchema<T> serSchema, Properties props) {
        throw new RuntimeException("KafkaSerializationSchema is only supported on the modern Kafka Connector.");
    }

    public abstract KafkaOffsetHandler createOffsetHandler();

    public abstract void restartBroker(int var1) throws Exception;

    public abstract void stopBroker(int var1) throws Exception;

    public abstract int getLeaderToShutDown(String var1) throws Exception;

    public abstract boolean isSecureRunSupported();

    protected void maybePrintDanglingThreadStacktrace(String threadNameKeyword) {
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : Thread.getAllStackTraces().entrySet()) {
            if (!threadEntry.getKey().getName().contains(threadNameKeyword)) continue;
            System.out.println("Dangling thread found:");
            for (StackTraceElement ste : threadEntry.getValue()) {
                System.out.println(ste);
            }
        }
    }

    public static interface KafkaOffsetHandler {
        public Long getCommittedOffset(String var1, int var2);

        public void setCommittedOffset(String var1, int var2, long var3);

        public void close();
    }

    public static class Config {
        private int numKafkaClusters = 1;
        private int kafkaServersNumber = 1;
        private Properties kafkaServerProperties = null;
        private boolean secureMode = false;

        private Config() {
        }

        public int getKafkaServersNumber() {
            return this.kafkaServersNumber;
        }

        public Config setKafkaServersNumber(int kafkaServersNumber) {
            this.kafkaServersNumber = kafkaServersNumber;
            return this;
        }

        public Properties getKafkaServerProperties() {
            return this.kafkaServerProperties;
        }

        public Config setKafkaServerProperties(Properties kafkaServerProperties) {
            this.kafkaServerProperties = kafkaServerProperties;
            return this;
        }

        public boolean isSecureMode() {
            return this.secureMode;
        }

        public Config setSecureMode(boolean secureMode) {
            this.secureMode = secureMode;
            return this;
        }

        public Config setHideKafkaBehindProxy(boolean hideKafkaBehindProxy) {
            return this;
        }
    }
}

