/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.io.IOException;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.ByteArrayInputView;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.streaming.util.serialization.SerializationSchema;

public class Utils {

    public static class TypeInformationSerializationSchema<T>
    implements DeserializationSchema<T>,
    SerializationSchema<T, byte[]> {
        private final TypeSerializer<T> serializer;
        private final TypeInformation<T> ti;

        public TypeInformationSerializationSchema(Object type, ExecutionConfig ec) {
            this.ti = TypeExtractor.getForObject((Object)type);
            this.serializer = this.ti.createSerializer(ec);
        }

        public T deserialize(byte[] message) {
            try {
                return (T)this.serializer.deserialize((DataInputView)new ByteArrayInputView(message));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to deserialize message", e);
            }
        }

        public boolean isEndOfStream(T nextElement) {
            return false;
        }

        public byte[] serialize(T element) {
            DataOutputSerializer dos = new DataOutputSerializer(16);
            try {
                this.serializer.serialize(element, (DataOutputView)dos);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to serialize record", e);
            }
            return dos.getByteArray();
        }

        public TypeInformation<T> getProducedType() {
            return this.ti;
        }
    }
}

