/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.kafka.api.KafkaSink;
import org.apache.flink.streaming.util.serialization.JavaDefaultStringSchema;

public class KafkaProducerExample {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: KafkaProducerExample <host> <port> <topic>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String topic = args[2];
        StreamExecutionEnvironment env = StreamExecutionEnvironment.createLocalEnvironment().setParallelism(4);
        env.addSource((SourceFunction)new SourceFunction<String>(){
            private volatile boolean running = true;

            public void run(SourceFunction.SourceContext<String> ctx) throws Exception {
                for (int i = 0; i < 20 && this.running; ++i) {
                    ctx.collect((Object)("message #" + i));
                    Thread.sleep(100L);
                }
                ctx.collect((Object)"q");
            }

            public void cancel() {
                this.running = false;
            }
        }).addSink(new KafkaSink(host + ":" + port, topic, new JavaDefaultStringSchema())).setParallelism(3);
        env.execute();
    }
}

