/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.kafka.api.KafkaSource;
import org.apache.flink.streaming.util.serialization.JavaDefaultStringSchema;

public class KafkaConsumerExample {
    private static String host;
    private static int port;
    private static String topic;

    public static void main(String[] args) throws Exception {
        if (!KafkaConsumerExample.parseParameters(args)) {
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.createLocalEnvironment().setParallelism(4);
        DataStreamSource kafkaStream = env.addSource(new KafkaSource(host + ":" + port, topic, new JavaDefaultStringSchema()));
        kafkaStream.print();
        env.execute();
    }

    private static boolean parseParameters(String[] args) {
        if (args.length == 3) {
            host = args[0];
            port = Integer.parseInt(args[1]);
            topic = args[2];
            return true;
        }
        System.err.println("Usage: KafkaConsumerExample <host> <port> <topic>");
        return false;
    }
}

