/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.security.SecureRandom;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.xa.JobSubtask;
import org.apache.flink.connector.jdbc.xa.XidGenerator;
import org.apache.flink.connector.jdbc.xa.XidImpl;

@Internal
class SemanticXidGenerator
implements XidGenerator {
    private static final long serialVersionUID = 1L;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final int FORMAT_ID = 201;
    private transient byte[] gtridBuffer;
    private transient byte[] bqualBuffer;

    SemanticXidGenerator() {
    }

    @Override
    public void open() {
        this.gtridBuffer = new byte[28];
        this.bqualBuffer = this.getRandomBytes(4);
    }

    @Override
    public Xid generateXid(JobSubtask subtaskId, long checkpointId) {
        System.arraycopy(subtaskId.getJobId(), 0, this.gtridBuffer, 0, 16);
        SemanticXidGenerator.writeNumber(subtaskId.getSubtaskId(), 4, this.gtridBuffer, 16);
        SemanticXidGenerator.writeNumber(checkpointId, 8, this.gtridBuffer, 20);
        return new XidImpl(201, this.gtridBuffer, this.bqualBuffer);
    }

    @Override
    public boolean belongsToSubtask(Xid xid, JobSubtask subtask) {
        if (xid.getFormatId() != 201) {
            return false;
        }
        int subtaskIndex = SemanticXidGenerator.readNumber(xid.getGlobalTransactionId(), 16, 4);
        if (subtaskIndex != subtask.getSubtaskId() && subtaskIndex <= subtask.getNumberOfSubtasks() - 1) {
            return false;
        }
        byte[] jobIdBytes = new byte[16];
        System.arraycopy(xid.getGlobalTransactionId(), 0, jobIdBytes, 0, 16);
        return Arrays.equals(jobIdBytes, subtask.getJobId());
    }

    private static int readNumber(byte[] bytes, int offset, int numBytes) {
        int result = 0;
        for (int i = 0; i < numBytes; ++i) {
            result |= (bytes[offset + i] & 0xFF) << 8 * i;
        }
        return result;
    }

    private static void writeNumber(long number, int numBytes, byte[] dst, int dstOffset) {
        for (int i = dstOffset; i < dstOffset + numBytes; ++i) {
            dst[i] = (byte)number;
            number >>>= 8;
        }
    }

    private byte[] getRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }
}

