/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.source.reader;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.jdbc.source.reader.JdbcRecordEmitter;
import org.apache.flink.connector.jdbc.source.reader.RecordAndOffset;
import org.apache.flink.connector.jdbc.source.split.JdbcSourceSplit;
import org.apache.flink.connector.jdbc.source.split.JdbcSourceSplitState;

public class JdbcSourceReader<OUT>
extends SingleThreadMultiplexSourceReaderBase<RecordAndOffset<OUT>, OUT, JdbcSourceSplit, JdbcSourceSplitState<JdbcSourceSplit>> {
    public JdbcSourceReader(Supplier<SplitReader<RecordAndOffset<OUT>, JdbcSourceSplit>> splitReaderSupplier, Configuration config, SourceReaderContext context) {
        super(splitReaderSupplier, new JdbcRecordEmitter(), config, context);
    }

    protected void onSplitFinished(Map<String, JdbcSourceSplitState<JdbcSourceSplit>> finishedSplitIds) {
        this.context.sendSplitRequest();
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.context.sendSplitRequest();
        }
    }

    protected JdbcSourceSplitState<JdbcSourceSplit> initializedState(JdbcSourceSplit split) {
        return new JdbcSourceSplitState<JdbcSourceSplit>(split);
    }

    protected JdbcSourceSplit toSplitType(String splitId, JdbcSourceSplitState<JdbcSourceSplit> splitState) {
        return splitState.toJdbcSourceSplit();
    }
}

