/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.source.enumerator;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.source.enumerator.JdbcSqlSplitEnumeratorBase;
import org.apache.flink.connector.jdbc.source.split.JdbcSourceSplit;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public final class SqlTemplateSplitEnumerator
extends JdbcSqlSplitEnumeratorBase<JdbcSourceSplit> {
    private final String sqlTemplate;
    private final JdbcParameterValuesProvider parameterValuesProvider;

    public SqlTemplateSplitEnumerator(Serializable userDefinedState, String sqlTemplate, @Nullable JdbcParameterValuesProvider parametersProvider) {
        super(userDefinedState);
        this.sqlTemplate = (String)Preconditions.checkNotNull((Object)sqlTemplate);
        this.parameterValuesProvider = parametersProvider;
    }

    @Override
    public List<JdbcSourceSplit> enumerateSplits() throws IOException {
        if (this.parameterValuesProvider == null) {
            return Collections.singletonList(new JdbcSourceSplit(this.getNextId(), this.sqlTemplate, null, 0, null));
        }
        Serializable[][] parameters = this.parameterValuesProvider.getParameterValues();
        if (parameters == null) {
            return Collections.singletonList(new JdbcSourceSplit(this.getNextId(), this.sqlTemplate, null, 0, null));
        }
        ArrayList<JdbcSourceSplit> jdbcSourceSplitList = new ArrayList<JdbcSourceSplit>(parameters.length);
        for (Serializable[] paramArr : parameters) {
            jdbcSourceSplitList.add(new JdbcSourceSplit(this.getNextId(), this.sqlTemplate, paramArr, 0, null));
        }
        return jdbcSourceSplitList;
    }

    @VisibleForTesting
    public String getSqlTemplate() {
        return this.sqlTemplate;
    }

    @VisibleForTesting
    public JdbcParameterValuesProvider getParameterValuesProvider() {
        return this.parameterValuesProvider;
    }

    public static class TemplateSqlSplitEnumeratorProvider
    implements JdbcSqlSplitEnumeratorBase.Provider<JdbcSourceSplit> {
        private String sqlTemplate;
        @Nullable
        private Serializable optionalSqlSplitEnumeratorState;
        @Nullable
        private JdbcParameterValuesProvider parameterValuesProvider;

        public TemplateSqlSplitEnumeratorProvider setSqlTemplate(String sqlTemplate) {
            Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)sqlTemplate) ? 1 : 0) != 0, (Object)"sqlTemplate must not be empty.");
            this.sqlTemplate = sqlTemplate;
            return this;
        }

        public TemplateSqlSplitEnumeratorProvider setParameterValuesProvider(@Nullable JdbcParameterValuesProvider parameterValuesProvider) {
            this.parameterValuesProvider = parameterValuesProvider;
            return this;
        }

        public TemplateSqlSplitEnumeratorProvider setOptionalSqlSplitEnumeratorState(Serializable optionalSqlSplitEnumeratorState) {
            this.optionalSqlSplitEnumeratorState = optionalSqlSplitEnumeratorState;
            return this;
        }

        @Override
        public JdbcSqlSplitEnumeratorBase<JdbcSourceSplit> create() {
            return new SqlTemplateSplitEnumerator(this.optionalSqlSplitEnumeratorState, this.sqlTemplate, this.parameterValuesProvider);
        }

        @Override
        public JdbcSqlSplitEnumeratorBase<JdbcSourceSplit> restore(@Nullable Serializable optionalSqlSplitEnumeratorState) {
            return new SqlTemplateSplitEnumerator(optionalSqlSplitEnumeratorState, this.sqlTemplate, this.parameterValuesProvider);
        }
    }
}

