/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.source.enumerator;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.jdbc.source.split.JdbcSourceSplit;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JdbcSourceEnumeratorState
implements Serializable {
    @Nonnull
    private final List<JdbcSourceSplit> completedSplits;
    @Nonnull
    private final List<JdbcSourceSplit> pendingSplits;
    @Nonnull
    private final List<JdbcSourceSplit> remainingSplits;
    @Nullable
    private final Serializable optionalUserDefinedSplitEnumeratorState;

    public JdbcSourceEnumeratorState(@Nonnull List<JdbcSourceSplit> completedSplits, @Nonnull List<JdbcSourceSplit> pendingSplits, @Nonnull List<JdbcSourceSplit> remainingSplits, @Nullable Serializable optionalUserDefinedSplitEnumeratorState) {
        this.completedSplits = (List)Preconditions.checkNotNull(completedSplits);
        this.pendingSplits = (List)Preconditions.checkNotNull(pendingSplits);
        this.remainingSplits = (List)Preconditions.checkNotNull(remainingSplits);
        this.optionalUserDefinedSplitEnumeratorState = optionalUserDefinedSplitEnumeratorState;
    }

    @Nullable
    public Serializable getOptionalUserDefinedSplitEnumeratorState() {
        return this.optionalUserDefinedSplitEnumeratorState;
    }

    @Nonnull
    public List<JdbcSourceSplit> getCompletedSplits() {
        return this.completedSplits;
    }

    @Nonnull
    public List<JdbcSourceSplit> getPendingSplits() {
        return this.pendingSplits;
    }

    @Nonnull
    public List<JdbcSourceSplit> getRemainingSplits() {
        return this.remainingSplits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcSourceEnumeratorState that = (JdbcSourceEnumeratorState)o;
        return Objects.equals(this.completedSplits, that.completedSplits) && Objects.equals(this.pendingSplits, that.pendingSplits) && Objects.equals(this.remainingSplits, that.remainingSplits) && Objects.equals(this.optionalUserDefinedSplitEnumeratorState, that.optionalUserDefinedSplitEnumeratorState);
    }

    public int hashCode() {
        return Objects.hash(this.completedSplits, this.pendingSplits, this.remainingSplits, this.optionalUserDefinedSplitEnumeratorState);
    }
}

