/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.table.data.RowData;

public final class TableBufferedStatementExecutor
implements JdbcBatchStatementExecutor<RowData> {
    private final JdbcBatchStatementExecutor<RowData> statementExecutor;
    private final List<RowData> buffer = new ArrayList<RowData>();

    public TableBufferedStatementExecutor(JdbcBatchStatementExecutor<RowData> statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.statementExecutor.prepareStatements(connection);
    }

    @Override
    public void addToBatch(RowData record) throws SQLException {
        this.buffer.add(record);
    }

    @Override
    public void executeBatch() throws SQLException {
        if (!this.buffer.isEmpty()) {
            for (RowData value : this.buffer) {
                this.statementExecutor.addToBatch(value);
            }
            this.statementExecutor.executeBatch();
            this.buffer.clear();
        }
    }

    @Override
    public void closeStatements() throws SQLException {
        this.statementExecutor.closeStatements();
    }
}

