/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.JdbcOutputSerializer;
import org.apache.flink.connector.jdbc.internal.RowJdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.executor.InsertOrUpdateJdbcExecutor;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatementImpl;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableJdbcUpsertOutputFormat
extends RowJdbcOutputFormat<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(TableJdbcUpsertOutputFormat.class);
    private JdbcBatchStatementExecutor<Row> deleteExecutor;
    private final JdbcOutputFormat.StatementExecutorFactory<JdbcBatchStatementExecutor<Row>> deleteStatementExecutorFactory;

    TableJdbcUpsertOutputFormat(JdbcConnectionProvider connectionProvider, JdbcDmlOptions dmlOptions, JdbcExecutionOptions batchOptions) {
        this(connectionProvider, batchOptions, (JdbcOutputFormat.StatementExecutorFactory & Serializable)() -> TableJdbcUpsertOutputFormat.createUpsertRowExecutor(dmlOptions), (JdbcOutputFormat.StatementExecutorFactory & Serializable)() -> TableJdbcUpsertOutputFormat.createDeleteExecutor(dmlOptions));
    }

    @VisibleForTesting
    TableJdbcUpsertOutputFormat(JdbcConnectionProvider connectionProvider, JdbcExecutionOptions batchOptions, JdbcOutputFormat.StatementExecutorFactory<JdbcBatchStatementExecutor<Row>> statementExecutorFactory, JdbcOutputFormat.StatementExecutorFactory<JdbcBatchStatementExecutor<Row>> deleteStatementExecutorFactory) {
        super(connectionProvider, batchOptions, statementExecutorFactory);
        this.deleteStatementExecutorFactory = deleteStatementExecutorFactory;
    }

    @Override
    public void open(@Nonnull JdbcOutputSerializer<Row> serializer) throws IOException {
        super.open(serializer);
        this.deleteExecutor = (JdbcBatchStatementExecutor)this.deleteStatementExecutorFactory.get();
        try {
            this.deleteExecutor.prepareStatements(this.connectionProvider.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private static JdbcBatchStatementExecutor<Row> createDeleteExecutor(JdbcDmlOptions dmlOptions) {
        int[] pkFields = Arrays.stream(dmlOptions.getFieldNames()).mapToInt(Arrays.asList(dmlOptions.getFieldNames())::indexOf).toArray();
        int[] pkTypes = dmlOptions.getFieldTypes() == null ? null : Arrays.stream(pkFields).map(f -> dmlOptions.getFieldTypes()[f]).toArray();
        String deleteSql = FieldNamedPreparedStatementImpl.parseNamedStatement(dmlOptions.getDialect().getDeleteStatement(dmlOptions.getTableName(), dmlOptions.getFieldNames()), new HashMap<String, List<Integer>>());
        return TableJdbcUpsertOutputFormat.createKeyedRowExecutor(pkFields, pkTypes, deleteSql);
    }

    @Override
    protected void addToBatch(Row original, Row extracted) throws SQLException {
        if (original.getKind() != RowKind.DELETE) {
            super.addToBatch(original, extracted);
        } else {
            this.deleteExecutor.addToBatch(extracted);
        }
    }

    @Override
    public synchronized void close() {
        try {
            super.close();
        }
        finally {
            try {
                if (this.deleteExecutor != null) {
                    this.deleteExecutor.closeStatements();
                }
            }
            catch (SQLException e) {
                LOG.warn("unable to close delete statement runner", (Throwable)e);
            }
        }
    }

    @Override
    protected void attemptFlush() throws SQLException {
        super.attemptFlush();
        this.deleteExecutor.executeBatch();
    }

    @Override
    public void updateExecutor(boolean reconnect) throws SQLException, ClassNotFoundException {
        super.updateExecutor(reconnect);
        this.deleteExecutor.closeStatements();
        this.deleteExecutor.prepareStatements(this.connectionProvider.getConnection());
    }

    private static JdbcBatchStatementExecutor<Row> createKeyedRowExecutor(int[] pkFields, int[] pkTypes, String sql) {
        return JdbcBatchStatementExecutor.keyed(sql, TableJdbcUpsertOutputFormat.createRowKeyExtractor(pkFields), (st, record) -> JdbcUtils.setRecordToStatement(st, pkTypes, TableJdbcUpsertOutputFormat.createRowKeyExtractor(pkFields).apply((Row)record)));
    }

    private static JdbcBatchStatementExecutor<Row> createUpsertRowExecutor(JdbcDmlOptions opt) {
        Preconditions.checkArgument((boolean)opt.getKeyFields().isPresent());
        int[] pkFields = Arrays.stream((Object[])opt.getKeyFields().get()).mapToInt(Arrays.asList(opt.getFieldNames())::indexOf).toArray();
        int[] pkTypes = opt.getFieldTypes() == null ? null : Arrays.stream(pkFields).map(f -> opt.getFieldTypes()[f]).toArray();
        return opt.getDialect().getUpsertStatement(opt.getTableName(), opt.getFieldNames(), opt.getKeyFields().get()).map(sql -> TableJdbcUpsertOutputFormat.createSimpleRowExecutor(TableJdbcUpsertOutputFormat.parseNamedStatement(sql), opt.getFieldTypes())).orElseGet(() -> new InsertOrUpdateJdbcExecutor<Row, Row, Row>(TableJdbcUpsertOutputFormat.parseNamedStatement(opt.getDialect().getRowExistsStatement(opt.getTableName(), opt.getKeyFields().get())), TableJdbcUpsertOutputFormat.parseNamedStatement(opt.getDialect().getInsertIntoStatement(opt.getTableName(), opt.getFieldNames())), TableJdbcUpsertOutputFormat.parseNamedStatement(opt.getDialect().getUpdateStatement(opt.getTableName(), opt.getFieldNames(), opt.getKeyFields().get())), TableJdbcUpsertOutputFormat.createRowJdbcStatementBuilder(pkTypes), TableJdbcUpsertOutputFormat.createRowJdbcStatementBuilder(opt.getFieldTypes()), TableJdbcUpsertOutputFormat.createRowJdbcStatementBuilder(opt.getFieldTypes()), TableJdbcUpsertOutputFormat.createRowKeyExtractor(pkFields), Function.identity()));
    }

    private static String parseNamedStatement(String statement) {
        return FieldNamedPreparedStatementImpl.parseNamedStatement(statement, new HashMap<String, List<Integer>>());
    }

    private static Function<Row, Row> createRowKeyExtractor(int[] pkFields) {
        return row -> JdbcUtils.getPrimaryKey(row, pkFields);
    }
}

