/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.JdbcOutputSerializer;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.util.Preconditions;

@Internal
public class GenericJdbcSinkFunction<T>
extends RichSinkFunction<T>
implements CheckpointedFunction,
InputTypeConfigurable {
    private final JdbcOutputFormat<T, ?, ?> outputFormat;
    private JdbcOutputSerializer<T> serializer;

    public GenericJdbcSinkFunction(@Nonnull JdbcOutputFormat<T, ?, ?> outputFormat) {
        this.outputFormat = (JdbcOutputFormat)Preconditions.checkNotNull(outputFormat);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.serializer.withObjectReuseEnabled(this.getRuntimeContext().getExecutionConfig().isObjectReuseEnabled());
        this.outputFormat.open(this.serializer);
    }

    public void invoke(T value, SinkFunction.Context context) throws IOException {
        this.outputFormat.writeRecord(value);
    }

    public void initializeState(FunctionInitializationContext context) {
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        this.outputFormat.flush();
    }

    public void close() {
        this.outputFormat.close();
    }

    public void setInputType(TypeInformation<?> type, ExecutionConfig executionConfig) {
        this.serializer = JdbcOutputSerializer.of(type.createSerializer(executionConfig));
    }
}

