/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.dialect;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class JdbcDialectLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDialectLoader.class);

    private JdbcDialectLoader() {
    }

    public static JdbcDialect load(String url, ClassLoader classLoader) {
        return JdbcDialectLoader.load(url, null, classLoader);
    }

    public static JdbcDialect load(String url, String compatibleMode, ClassLoader classLoader) {
        List<JdbcDialectFactory> foundFactories = JdbcDialectLoader.discoverFactories(classLoader);
        if (foundFactories.isEmpty()) {
            throw new IllegalStateException(String.format("Could not find any jdbc dialect factories that implement '%s' in the classpath.", JdbcDialectFactory.class.getName()));
        }
        List matchingFactories = foundFactories.stream().filter(f -> f.acceptsURL(url)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new IllegalStateException(String.format("Could not find any jdbc dialect factory that can handle url '%s' that implements '%s' in the classpath.\n\nAvailable factories are:\n\n%s", url, JdbcDialectFactory.class.getName(), foundFactories.stream().map(f -> f.getClass().getName()).distinct().sorted().collect(Collectors.joining("\n"))));
        }
        if (matchingFactories.size() > 1) {
            throw new IllegalStateException(String.format("Multiple jdbc dialect factories can handle url '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", url, JdbcDialectFactory.class.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return ((JdbcDialectFactory)matchingFactories.get(0)).create(compatibleMode);
    }

    private static List<JdbcDialectFactory> discoverFactories(ClassLoader classLoader) {
        try {
            LinkedList<JdbcDialectFactory> result = new LinkedList<JdbcDialectFactory>();
            ServiceLoader.load(JdbcDialectFactory.class, classLoader).iterator().forEachRemaining(result::add);
            return result;
        }
        catch (ServiceConfigurationError e) {
            LOG.error("Could not load service provider for jdbc dialects factory.", (Throwable)e);
            throw new RuntimeException("Could not load service provider for jdbc dialects factory.", e);
        }
    }
}

