/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.datasource.transactions.xa.exceptions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.datasource.transactions.xa.exceptions.TransientXaException;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class XaError {
    private static final Set<Integer> TRANSIENT_ERR_CODES = new HashSet<Integer>(Arrays.asList(107, -7));
    private static final Set<Integer> HEUR_ERR_CODES = new HashSet<Integer>(Arrays.asList(6, 7, 8, 5));

    public static boolean isHeurErrorCode(int errorCode) {
        return HEUR_ERR_CODES.contains(errorCode);
    }

    public static FlinkRuntimeException wrapException(String action, Exception ex) {
        return XaError.wrapException(action, null, ex);
    }

    public static FlinkRuntimeException wrapException(String action, Xid xid, Exception ex) {
        if (ex instanceof XAException) {
            XAException xa = (XAException)ex;
            if (TRANSIENT_ERR_CODES.contains(xa.errorCode)) {
                throw new TransientXaException(xa);
            }
            throw new FlinkRuntimeException(XaError.errorMessage(action, xid, xa.errorCode, xa.getMessage()));
        }
        throw new FlinkRuntimeException(XaError.errorMessage(action, xid, ex.getMessage()), (Throwable)ex);
    }

    public static Optional<String> buildCommitErrorDesc(XAException err, boolean ignoreUnknown) {
        if (err.errorCode == 7) {
            return Optional.of("transaction was heuristically committed earlier");
        }
        if (ignoreUnknown && err.errorCode == -4) {
            return Optional.of("transaction is unknown to RM (ignoring)");
        }
        return Optional.empty();
    }

    public static Optional<String> buildRollbackErrorDesc(XAException err) {
        if (err.errorCode == 6) {
            return Optional.of("transaction was already heuristically rolled back");
        }
        if (err.errorCode >= 100) {
            return Optional.of("transaction was already marked for rollback");
        }
        return Optional.empty();
    }

    public static String errorMessage(String action, Xid xid, String ... more) {
        return XaError.errorMessage(action, xid, null, more);
    }

    public static String errorMessage(String action, Xid xid, Integer code, String ... more) {
        String message = String.join((CharSequence)", ", XaError.actionErrorMessage(action), XaError.xidErrorMessage(xid), XaError.codeErrorMessage(code));
        return String.join((CharSequence)". ", message, XaError.moreErrorMessage(more));
    }

    private static String actionErrorMessage(String action) {
        if (action == null) {
            return "";
        }
        return String.format("Unable to %s", action);
    }

    private static String xidErrorMessage(Xid xid) {
        if (xid == null) {
            return "";
        }
        return String.format("XA transaction with xid %s", xid);
    }

    private static String codeErrorMessage(Integer errorCode) {
        if (errorCode == null) {
            return "";
        }
        return String.format("Error %d: %s", errorCode, XaError.translateCode(errorCode));
    }

    private static String moreErrorMessage(String ... more) {
        if (more == null || more.length == 0) {
            return "";
        }
        return Arrays.toString(more);
    }

    private static String translateCode(int code) {
        switch (code) {
            case 7: {
                return "heuristic commit decision was made";
            }
            case 8: {
                return "heuristic decision may have been made";
            }
            case 5: {
                return "heuristic mixed decision was made";
            }
            case 6: {
                return "heuristic rollback decision was made";
            }
            case 9: {
                return "the transaction resumption must happen where the suspension occurred";
            }
            case 101: {
                return "rollback happened due to a communications failure";
            }
            case 102: {
                return "rollback happened because deadlock was detected";
            }
            case 103: {
                return "rollback happened because an internal integrity check failed";
            }
            case 104: {
                return "rollback happened for some reason not fitting any of the other rollback error codes";
            }
            case 105: {
                return "rollback happened due to a protocol error in the resource manager";
            }
            case 100: {
                return "rollback happened for an unspecified reason";
            }
            case 106: {
                return "rollback happened because of a timeout";
            }
            case 107: {
                return "rollback happened due to a transient failure";
            }
            case 3: {
                return "the transaction branch was read-only, and has already been committed";
            }
            case 4: {
                return "the method invoked returned without having any effect, and that it may be invoked again";
            }
            case -2: {
                return "an asynchronous operation is outstanding";
            }
            case -8: {
                return "Xid given as an argument is already known to the resource manager";
            }
            case -5: {
                return "invalid arguments were passed";
            }
            case -4: {
                return "Xid is not valid";
            }
            case -9: {
                return "the resource manager is doing work outside the global transaction";
            }
            case -6: {
                return "protocol error";
            }
            case -3: {
                return "resource manager error has occurred";
            }
            case -7: {
                return "the resource manager has failed and is not available";
            }
        }
        return "";
    }
}

