/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.databases.postgres.catalog;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public class PostgresTablePath {
    private static final String DEFAULT_POSTGRES_SCHEMA_NAME = "public";
    private final String pgSchemaName;
    private final String pgTableName;

    public PostgresTablePath(String pgSchemaName, String pgTableName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)pgSchemaName) ? 1 : 0) != 0, (Object)"Schema name is not valid. Null or empty is not allowed");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)pgTableName) ? 1 : 0) != 0, (Object)"Table name is not valid. Null or empty is not allowed");
        this.pgSchemaName = pgSchemaName;
        this.pgTableName = pgTableName;
    }

    public static PostgresTablePath fromFlinkTableName(String flinkTableName) {
        if (flinkTableName.contains(".")) {
            String[] path = flinkTableName.split("\\.");
            Preconditions.checkArgument((path != null && path.length == 2 ? 1 : 0) != 0, (Object)String.format("Table name '%s' is not valid. The parsed length is %d", flinkTableName, path.length));
            return new PostgresTablePath(path[0], path[1]);
        }
        return new PostgresTablePath(PostgresTablePath.getDefaultSchemaName(), flinkTableName);
    }

    public static String toFlinkTableName(String schema, String table) {
        return new PostgresTablePath(schema, table).getFullPath();
    }

    public String getFullPath() {
        return String.format("%s.%s", this.pgSchemaName, this.pgTableName);
    }

    public String getPgTableName() {
        return this.pgTableName;
    }

    public String getPgSchemaName() {
        return this.pgSchemaName;
    }

    protected static String getDefaultSchemaName() {
        return DEFAULT_POSTGRES_SCHEMA_NAME;
    }

    public String toString() {
        return this.getFullPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostgresTablePath that = (PostgresTablePath)o;
        return Objects.equals(this.pgSchemaName, that.pgSchemaName) && Objects.equals(this.pgTableName, that.pgTableName);
    }

    public int hashCode() {
        return Objects.hash(this.pgSchemaName, this.pgTableName);
    }
}

