/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.databases.cratedb.catalog;

import org.apache.flink.connector.jdbc.databases.postgres.catalog.PostgresTablePath;
import org.apache.flink.util.Preconditions;

public class CrateDBTablePath
extends PostgresTablePath {
    private static final String DEFAULT_CRATE_SCHEMA_NAME = "doc";

    public CrateDBTablePath(String pgSchemaName, String pgTableName) {
        super(pgSchemaName, pgTableName);
    }

    public static CrateDBTablePath fromFlinkTableName(String flinkTableName) {
        if (flinkTableName.contains(".")) {
            String[] path = flinkTableName.split("\\.");
            Preconditions.checkArgument((path.length == 2 ? 1 : 0) != 0, (Object)String.format("Table name '%s' is not valid. The parsed length is %d", flinkTableName, path.length));
            return new CrateDBTablePath(path[0], path[1]);
        }
        return new CrateDBTablePath(CrateDBTablePath.getDefaultSchemaName(), flinkTableName);
    }

    public static String toFlinkTableName(String schema, String table) {
        return new PostgresTablePath(schema, table).getFullPath();
    }

    protected static String getDefaultSchemaName() {
        return DEFAULT_CRATE_SCHEMA_NAME;
    }
}

