/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Experimental
public class JdbcInputFormat
extends RichInputFormat<Row, InputSplit>
implements ResultTypeQueryable<Row> {
    protected static final long serialVersionUID = 2L;
    protected static final Logger LOG = LoggerFactory.getLogger(JdbcInputFormat.class);
    protected JdbcConnectionProvider connectionProvider;
    protected String queryTemplate;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected RowTypeInfo rowTypeInfo;
    protected transient PreparedStatement statement;
    protected transient ResultSet resultSet;
    protected int fetchSize;
    protected Boolean autoCommit;
    protected boolean hasNext;
    protected Object[][] parameterValues;

    public RowTypeInfo getProducedType() {
        return this.rowTypeInfo;
    }

    public void configure(Configuration parameters) {
    }

    public void openInputFormat() {
        try {
            Connection dbConn = this.connectionProvider.getOrEstablishConnection();
            if (this.autoCommit != null) {
                dbConn.setAutoCommit(this.autoCommit);
            }
            this.statement = dbConn.prepareStatement(this.queryTemplate, this.resultSetType, this.resultSetConcurrency);
            if (this.fetchSize == Integer.MIN_VALUE || this.fetchSize > 0) {
                this.statement.setFetchSize(this.fetchSize);
            }
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("open() failed." + se.getMessage(), se);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC-Class not found. - " + cnfe.getMessage(), cnfe);
        }
    }

    public void closeInputFormat() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException se) {
            LOG.info("Inputformat Statement couldn't be closed - " + se.getMessage());
        }
        finally {
            this.statement = null;
        }
        this.connectionProvider.closeConnection();
        this.parameterValues = null;
    }

    public void open(InputSplit inputSplit) throws IOException {
        try {
            if (inputSplit != null && this.parameterValues != null) {
                for (int i = 0; i < this.parameterValues[inputSplit.getSplitNumber()].length; ++i) {
                    Object param = this.parameterValues[inputSplit.getSplitNumber()][i];
                    if (param instanceof String) {
                        this.statement.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Long) {
                        this.statement.setLong(i + 1, (Long)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        this.statement.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Double) {
                        this.statement.setDouble(i + 1, (Double)param);
                        continue;
                    }
                    if (param instanceof Boolean) {
                        this.statement.setBoolean(i + 1, (Boolean)param);
                        continue;
                    }
                    if (param instanceof Float) {
                        this.statement.setFloat(i + 1, ((Float)param).floatValue());
                        continue;
                    }
                    if (param instanceof BigDecimal) {
                        this.statement.setBigDecimal(i + 1, (BigDecimal)param);
                        continue;
                    }
                    if (param instanceof Byte) {
                        this.statement.setByte(i + 1, (Byte)param);
                        continue;
                    }
                    if (param instanceof Short) {
                        this.statement.setShort(i + 1, (Short)param);
                        continue;
                    }
                    if (param instanceof Date) {
                        this.statement.setDate(i + 1, (Date)param);
                        continue;
                    }
                    if (param instanceof Time) {
                        this.statement.setTime(i + 1, (Time)param);
                        continue;
                    }
                    if (param instanceof Timestamp) {
                        this.statement.setTimestamp(i + 1, (Timestamp)param);
                        continue;
                    }
                    if (param instanceof Array) {
                        this.statement.setArray(i + 1, (Array)param);
                        continue;
                    }
                    throw new IllegalArgumentException("open() failed. Parameter " + i + " of type " + param.getClass() + " is not handled (yet).");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Executing '%s' with parameters %s", this.queryTemplate, Arrays.deepToString(this.parameterValues[inputSplit.getSplitNumber()])));
                }
            }
            this.resultSet = this.statement.executeQuery();
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("open() failed." + se.getMessage(), se);
        }
    }

    public void close() throws IOException {
        if (this.resultSet == null) {
            return;
        }
        try {
            this.resultSet.close();
        }
        catch (SQLException se) {
            LOG.info("Inputformat ResultSet couldn't be closed - " + se.getMessage());
        }
    }

    public boolean reachedEnd() throws IOException {
        return !this.hasNext;
    }

    public Row nextRecord(Row reuse) throws IOException {
        try {
            if (!this.hasNext) {
                return null;
            }
            for (int pos = 0; pos < reuse.getArity(); ++pos) {
                reuse.setField(pos, this.resultSet.getObject(pos + 1));
            }
            this.hasNext = this.resultSet.next();
            return reuse;
        }
        catch (SQLException se) {
            throw new IOException("Couldn't read data - " + se.getMessage(), se);
        }
        catch (NullPointerException npe) {
            throw new IOException("Couldn't access resultSet", npe);
        }
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
        return cachedStatistics;
    }

    public InputSplit[] createInputSplits(int minNumSplits) throws IOException {
        if (this.parameterValues == null) {
            return new GenericInputSplit[]{new GenericInputSplit(0, 1)};
        }
        GenericInputSplit[] ret = new GenericInputSplit[this.parameterValues.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new GenericInputSplit(i, ret.length);
        }
        return ret;
    }

    public InputSplitAssigner getInputSplitAssigner(InputSplit[] inputSplits) {
        return new DefaultInputSplitAssigner(inputSplits);
    }

    @VisibleForTesting
    protected PreparedStatement getStatement() {
        return this.statement;
    }

    @VisibleForTesting
    protected Connection getDbConn() {
        return this.connectionProvider.getConnection();
    }

    public static JdbcInputFormatBuilder buildJdbcInputFormat() {
        return new JdbcInputFormatBuilder();
    }

    public static class JdbcInputFormatBuilder {
        private final JdbcConnectionOptions.JdbcConnectionOptionsBuilder connOptionsBuilder = new JdbcConnectionOptions.JdbcConnectionOptionsBuilder();
        private final JdbcInputFormat format = new JdbcInputFormat();

        public JdbcInputFormatBuilder() {
            this.format.resultSetType = 1003;
            this.format.resultSetConcurrency = 1007;
        }

        public JdbcInputFormatBuilder setUsername(String username) {
            this.connOptionsBuilder.withUsername(username);
            return this;
        }

        public JdbcInputFormatBuilder setPassword(String password) {
            this.connOptionsBuilder.withPassword(password);
            return this;
        }

        public JdbcInputFormatBuilder setDrivername(String drivername) {
            this.connOptionsBuilder.withDriverName(drivername);
            return this;
        }

        public JdbcInputFormatBuilder setDBUrl(String dbURL) {
            this.connOptionsBuilder.withUrl(dbURL);
            return this;
        }

        public JdbcInputFormatBuilder setQuery(String query) {
            this.format.queryTemplate = query;
            return this;
        }

        public JdbcInputFormatBuilder setResultSetType(int resultSetType) {
            this.format.resultSetType = resultSetType;
            return this;
        }

        public JdbcInputFormatBuilder setResultSetConcurrency(int resultSetConcurrency) {
            this.format.resultSetConcurrency = resultSetConcurrency;
            return this;
        }

        public JdbcInputFormatBuilder setParametersProvider(JdbcParameterValuesProvider parameterValuesProvider) {
            this.format.parameterValues = parameterValuesProvider.getParameterValues();
            return this;
        }

        public JdbcInputFormatBuilder setRowTypeInfo(RowTypeInfo rowTypeInfo) {
            this.format.rowTypeInfo = rowTypeInfo;
            return this;
        }

        public JdbcInputFormatBuilder setFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize == Integer.MIN_VALUE || fetchSize > 0 ? 1 : 0) != 0, (String)"Illegal value %s for fetchSize, has to be positive or Integer.MIN_VALUE.", (Object[])new Object[]{fetchSize});
            this.format.fetchSize = fetchSize;
            return this;
        }

        public JdbcInputFormatBuilder setAutoCommit(Boolean autoCommit) {
            this.format.autoCommit = autoCommit;
            return this;
        }

        public JdbcInputFormat finish() {
            this.format.connectionProvider = new SimpleJdbcConnectionProvider(this.connOptionsBuilder.build());
            if (this.format.queryTemplate == null) {
                throw new NullPointerException("No query supplied");
            }
            if (this.format.rowTypeInfo == null) {
                throw new NullPointerException("No " + RowTypeInfo.class.getSimpleName() + " supplied");
            }
            if (this.format.parameterValues == null) {
                LOG.debug("No input splitting configured (data will be read with parallelism 1).");
            }
            return this.format;
        }
    }
}

