/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.databases.sqlserver.dialect;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.databases.sqlserver.dialect.SqlServerRowConverter;
import org.apache.flink.connector.jdbc.dialect.AbstractDialect;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class SqlServerDialect
extends AbstractDialect {
    @Override
    public String dialectName() {
        return "SqlServer";
    }

    @Override
    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of(0, 7));
    }

    @Override
    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of(0, 38));
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(f -> !Arrays.asList(uniqueKeyFields).contains(f)).collect(Collectors.toList());
        String fieldsProjection = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String valuesBinding = Arrays.stream(fieldNames).map(f -> ":" + f + " " + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String usingClause = String.format("SELECT %s", valuesBinding);
        String onConditions = Arrays.stream(uniqueKeyFields).map(f -> "[TARGET]." + this.quoteIdentifier((String)f) + "=[SOURCE]." + this.quoteIdentifier((String)f)).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(f -> "[TARGET]." + this.quoteIdentifier((String)f) + "=[SOURCE]." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(f -> "[SOURCE]." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        return Optional.of(String.format("MERGE INTO %s AS [TARGET] USING (%s) AS [SOURCE] ON (%s) WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s);", this.quoteIdentifier(tableName), usingClause, onConditions, updateSetClause, fieldsProjection, insertValues));
    }

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new SqlServerRowConverter(rowType);
    }

    @Override
    public String getLimitClause(long limit) {
        throw new IllegalArgumentException("SqlServerDialect does not support limit clause");
    }

    @Override
    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.BINARY, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE});
    }
}

