/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.catalog;

import org.apache.flink.connector.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.catalog.MySqlCatalog;
import org.apache.flink.connector.jdbc.catalog.PostgresCatalog;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectLoader;
import org.apache.flink.connector.jdbc.dialect.mysql.MySqlDialect;
import org.apache.flink.connector.jdbc.dialect.psql.PostgresDialect;
import org.apache.flink.util.Preconditions;

public class JdbcCatalogUtils {
    public static void validateJdbcUrl(String url) {
        String[] parts = url.trim().split("\\/+");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0);
    }

    public static AbstractJdbcCatalog createCatalog(String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        JdbcDialect dialect = JdbcDialectLoader.load(baseUrl);
        if (dialect instanceof PostgresDialect) {
            return new PostgresCatalog(catalogName, defaultDatabase, username, pwd, baseUrl);
        }
        if (dialect instanceof MySqlDialect) {
            return new MySqlCatalog(catalogName, defaultDatabase, username, pwd, baseUrl);
        }
        throw new UnsupportedOperationException(String.format("Catalog for '%s' is not supported yet.", dialect));
    }
}

