/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.source;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.connector.hbase.util.HBaseSerde;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HBaseRowDataLookupFunction
extends LookupFunction {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRowDataLookupFunction.class);
    private static final long serialVersionUID = 1L;
    private final String hTableName;
    private final byte[] serializedConfig;
    private final HBaseTableSchema hbaseTableSchema;
    private final String nullStringLiteral;
    private transient Connection hConnection;
    private transient HTable table;
    private transient HBaseSerde serde;
    private final int maxRetryTimes;

    public HBaseRowDataLookupFunction(Configuration configuration, String hTableName, HBaseTableSchema hbaseTableSchema, String nullStringLiteral, int maxRetryTimes) {
        this.serializedConfig = HBaseConfigurationUtil.serializeConfiguration(configuration);
        this.hTableName = hTableName;
        this.hbaseTableSchema = hbaseTableSchema;
        this.nullStringLiteral = nullStringLiteral;
        this.maxRetryTimes = maxRetryTimes;
    }

    public Collection<RowData> lookup(RowData keyRow) throws IOException {
        for (int retry = 0; retry <= this.maxRetryTimes; ++retry) {
            try {
                Result result;
                Get get = this.serde.createGet(((GenericRowData)keyRow).getField(0));
                if (get != null && !(result = this.table.get(get)).isEmpty()) {
                    return Collections.singletonList(this.serde.convertToReusedRow(result));
                }
                break;
            }
            catch (IOException e) {
                LOG.error(String.format("HBase lookup error, retry times = %d", retry), (Throwable)e);
                if (retry >= this.maxRetryTimes) {
                    throw new RuntimeException("Execution of HBase lookup failed.", e);
                }
                try {
                    Thread.sleep(1000 * retry);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return Collections.emptyList();
    }

    private Configuration prepareRuntimeConfiguration() {
        Configuration runtimeConfig = HBaseConfigurationUtil.deserializeConfiguration(this.serializedConfig, HBaseConfigurationUtil.getHBaseConfiguration());
        if (StringUtils.isNullOrWhitespaceOnly((String)runtimeConfig.get("hbase.zookeeper.quorum"))) {
            LOG.error("can not connect to HBase without {} configuration", (Object)"hbase.zookeeper.quorum");
            throw new IllegalArgumentException("check HBase configuration failed, lost: 'hbase.zookeeper.quorum'!");
        }
        return runtimeConfig;
    }

    public void open(FunctionContext context) {
        LOG.info("start open ...");
        Configuration config = this.prepareRuntimeConfiguration();
        try {
            this.hConnection = ConnectionFactory.createConnection((Configuration)config);
            this.table = (HTable)this.hConnection.getTable(TableName.valueOf((String)this.hTableName));
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("Table '{}' not found ", (Object)this.hTableName, (Object)tnfe);
            throw new RuntimeException("HBase table '" + this.hTableName + "' not found.", tnfe);
        }
        catch (IOException ioe) {
            LOG.error("Exception while creating connection to HBase.", (Throwable)ioe);
            throw new RuntimeException("Cannot create connection to HBase.", ioe);
        }
        this.serde = new HBaseSerde(this.hbaseTableSchema, this.nullStringLiteral);
        LOG.info("end open.");
    }

    public void close() {
        LOG.info("start close ...");
        if (null != this.table) {
            try {
                this.table.close();
                this.table = null;
            }
            catch (IOException e) {
                LOG.warn("exception when close table", (Throwable)e);
            }
        }
        if (null != this.hConnection) {
            try {
                this.hConnection.close();
                this.hConnection = null;
            }
            catch (IOException e) {
                LOG.warn("exception when close connection", (Throwable)e);
            }
        }
        LOG.info("end close.");
    }

    @VisibleForTesting
    public String getHTableName() {
        return this.hTableName;
    }
}

