/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HBaseConfigurationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseConfigurationUtil.class);
    public static final String ENV_HBASE_CONF_DIR = "HBASE_CONF_DIR";

    public static Configuration getHBaseConfiguration() {
        String hbaseConfDir;
        Configuration result = HBaseConfiguration.create();
        boolean foundHBaseConfiguration = false;
        String possibleHBaseConfPath = null;
        String hbaseHome = System.getenv("HBASE_HOME");
        if (hbaseHome != null) {
            LOG.debug("Searching HBase configuration files in HBASE_HOME: {}", (Object)hbaseHome);
            possibleHBaseConfPath = hbaseHome + "/conf";
        }
        if (possibleHBaseConfPath != null) {
            foundHBaseConfiguration = HBaseConfigurationUtil.addHBaseConfIfFound(result, possibleHBaseConfPath);
        }
        if ((hbaseConfDir = System.getenv(ENV_HBASE_CONF_DIR)) != null) {
            LOG.debug("Searching HBase configuration files in HBASE_CONF_DIR: {}", (Object)hbaseConfDir);
            boolean bl = foundHBaseConfiguration = HBaseConfigurationUtil.addHBaseConfIfFound(result, hbaseConfDir) || foundHBaseConfiguration;
        }
        if (!foundHBaseConfiguration) {
            LOG.warn("Could not find HBase configuration via any of the supported methods (Flink configuration, environment variables).");
        }
        return result;
    }

    private static boolean addHBaseConfIfFound(Configuration configuration, String possibleHBaseConfPath) {
        boolean foundHBaseConfiguration = false;
        if (new File(possibleHBaseConfPath).exists()) {
            if (new File(possibleHBaseConfPath + "/hbase-default.xml").exists()) {
                configuration.addResource(new Path(possibleHBaseConfPath + "/hbase-default.xml"));
                LOG.debug("Adding " + possibleHBaseConfPath + "/hbase-default.xml to hbase configuration");
                foundHBaseConfiguration = true;
            }
            if (new File(possibleHBaseConfPath + "/hbase-site.xml").exists()) {
                configuration.addResource(new Path(possibleHBaseConfPath + "/hbase-site.xml"));
                LOG.debug("Adding " + possibleHBaseConfPath + "/hbase-site.xml to hbase configuration");
                foundHBaseConfiguration = true;
            }
        }
        return foundHBaseConfiguration;
    }

    public static byte[] serializeConfiguration(Configuration conf) {
        try {
            return HBaseConfigurationUtil.serializeWritable(conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Encounter an IOException when serialize the Configuration.", e);
        }
    }

    public static Configuration deserializeConfiguration(byte[] serializedConfig, Configuration targetConfig) {
        if (null == targetConfig) {
            targetConfig = new Configuration();
        }
        try {
            HBaseConfigurationUtil.deserializeWritable(targetConfig, serializedConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Encounter an IOException when deserialize the Configuration.", e);
        }
        return targetConfig;
    }

    private static <T extends Writable> byte[] serializeWritable(T writable) throws IOException {
        Preconditions.checkArgument((writable != null ? 1 : 0) != 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        writable.write((DataOutput)outputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static <T extends Writable> void deserializeWritable(T writable, byte[] bytes) throws IOException {
        Preconditions.checkArgument((writable != null ? 1 : 0) != 0);
        Preconditions.checkArgument((bytes != null ? 1 : 0) != 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        writable.readFields((DataInput)dataInputStream);
    }

    public static Configuration createHBaseConf() {
        Configuration hbaseClientConf = HBaseConfiguration.create();
        String hbaseConfDir = System.getenv(ENV_HBASE_CONF_DIR);
        if (hbaseConfDir != null) {
            if (new File(hbaseConfDir).exists()) {
                String coreSite = hbaseConfDir + "/core-site.xml";
                String hdfsSite = hbaseConfDir + "/hdfs-site.xml";
                String hbaseSite = hbaseConfDir + "/hbase-site.xml";
                if (new File(coreSite).exists()) {
                    hbaseClientConf.addResource(new Path(coreSite));
                    LOG.info("Adding " + coreSite + " to hbase configuration");
                }
                if (new File(hdfsSite).exists()) {
                    hbaseClientConf.addResource(new Path(hdfsSite));
                    LOG.info("Adding " + hdfsSite + " to hbase configuration");
                }
                if (new File(hbaseSite).exists()) {
                    hbaseClientConf.addResource(new Path(hbaseSite));
                    LOG.info("Adding " + hbaseSite + " to hbase configuration");
                }
            } else {
                LOG.warn("HBase config directory '{}' not found, cannot load HBase configuration.", (Object)hbaseConfDir);
            }
        } else {
            LOG.warn("{} env variable not found, cannot load HBase configuration.", (Object)ENV_HBASE_CONF_DIR);
        }
        return hbaseClientConf;
    }
}

