/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase1.source;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.hbase.source.TableInputSplit;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractTableInputFormat<T>
extends RichInputFormat<T, TableInputSplit> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTableInputFormat.class);
    private static final long serialVersionUID = 1L;
    protected boolean endReached = false;
    protected transient Connection connection = null;
    protected transient HTable table = null;
    protected transient Scan scan = null;
    protected ResultScanner resultScanner = null;
    protected byte[] currentRow;
    protected long scannedRows;
    protected byte[] serializedConfig;

    public AbstractTableInputFormat(org.apache.hadoop.conf.Configuration hConf) {
        this.serializedConfig = HBaseConfigurationUtil.serializeConfiguration((org.apache.hadoop.conf.Configuration)hConf);
    }

    protected abstract void initTable() throws IOException;

    protected abstract Scan getScanner();

    protected abstract String getTableName();

    protected abstract T mapResultToOutType(Result var1);

    public void configure(Configuration parameters) {
    }

    protected org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
        return HBaseConfigurationUtil.deserializeConfiguration((byte[])this.serializedConfig, (org.apache.hadoop.conf.Configuration)HBaseConfigurationUtil.getHBaseConfiguration());
    }

    public void open(TableInputSplit split) throws IOException {
        this.initTable();
        if (split == null) {
            throw new IOException("Input split is null!");
        }
        this.logSplitInfo("opening", split);
        this.currentRow = split.getStartRow();
        this.scan.setStartRow(this.currentRow);
        this.scan.setStopRow(split.getEndRow());
        this.resultScanner = this.table.getScanner(this.scan);
        this.endReached = false;
        this.scannedRows = 0L;
    }

    public T nextRecord(T reuse) throws IOException {
        Result res;
        if (this.resultScanner == null) {
            throw new IOException("No table result scanner provided!");
        }
        try {
            res = this.resultScanner.next();
        }
        catch (Exception e) {
            this.resultScanner.close();
            LOG.warn("Error after scan of " + this.scannedRows + " rows. Retry with a new scanner...", (Throwable)e);
            this.scan.withStartRow(this.currentRow, false);
            this.resultScanner = this.table.getScanner(this.scan);
            res = this.resultScanner.next();
        }
        if (res != null) {
            ++this.scannedRows;
            this.currentRow = res.getRow();
            return this.mapResultToOutType(res);
        }
        this.endReached = true;
        return null;
    }

    private void logSplitInfo(String action, TableInputSplit split) {
        int splitId = split.getSplitNumber();
        String splitStart = Bytes.toString((byte[])split.getStartRow());
        String splitEnd = Bytes.toString((byte[])split.getEndRow());
        String splitStartKey = splitStart.isEmpty() ? "-" : splitStart;
        String splitStopKey = splitEnd.isEmpty() ? "-" : splitEnd;
        String[] hostnames = split.getHostnames();
        LOG.info("{} split (this={})[{}|{}|{}|{}]", new Object[]{action, this, splitId, hostnames, splitStartKey, splitStopKey});
    }

    public boolean reachedEnd() throws IOException {
        return this.endReached;
    }

    public void close() throws IOException {
        LOG.info("Closing split (scanned {} rows)", (Object)this.scannedRows);
        this.currentRow = null;
        try {
            if (this.resultScanner != null) {
                this.resultScanner.close();
            }
            this.closeTable();
        }
        finally {
            this.resultScanner = null;
        }
    }

    public void closeTable() {
        if (this.table != null) {
            try {
                this.table.close();
            }
            catch (IOException e) {
                LOG.warn("Exception occurs while closing HBase Table.", (Throwable)e);
            }
            this.table = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                LOG.warn("Exception occurs while closing HBase Connection.", (Throwable)e);
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        try {
            this.initTable();
            Pair keys = this.table.getRegionLocator().getStartEndKeys();
            if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
                LOG.warn("Unexpected region keys: {} appeared in HBase table: {}, all region information are: {}.", new Object[]{keys, this.table, this.table.getRegionLocator().getAllRegionLocations()});
                throw new IOException("HBase Table expects at least one region in scan, please check the HBase table status in HBase cluster");
            }
            byte[] startRow = this.scan.getStartRow();
            byte[] stopRow = this.scan.getStopRow();
            boolean scanWithNoLowerBound = startRow.length == 0;
            boolean scanWithNoUpperBound = stopRow.length == 0;
            ArrayList<TableInputSplit> splits = new ArrayList<TableInputSplit>(minNumSplits);
            for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
                boolean isLastRegion;
                byte[] startKey = ((byte[][])keys.getFirst())[i];
                byte[] endKey = ((byte[][])keys.getSecond())[i];
                String regionLocation = this.table.getRegionLocator().getRegionLocation(startKey, false).getHostnamePort();
                if (!this.includeRegionInScan(startKey, endKey)) continue;
                String[] hosts = new String[]{regionLocation};
                boolean bl = isLastRegion = endKey.length == 0;
                if (!scanWithNoLowerBound && !isLastRegion && Bytes.compareTo((byte[])startRow, (byte[])endKey) >= 0 || !scanWithNoUpperBound && Bytes.compareTo((byte[])stopRow, (byte[])startKey) <= 0) continue;
                byte[] splitStart = scanWithNoLowerBound || Bytes.compareTo((byte[])startKey, (byte[])startRow) >= 0 ? startKey : startRow;
                byte[] splitStop = (scanWithNoUpperBound || Bytes.compareTo((byte[])endKey, (byte[])stopRow) <= 0) && !isLastRegion ? endKey : stopRow;
                int id = splits.size();
                TableInputSplit split = new TableInputSplit(id, hosts, this.table.getTableName(), splitStart, splitStop);
                splits.add(split);
            }
            LOG.info("Created " + splits.size() + " splits");
            for (TableInputSplit split : splits) {
                this.logSplitInfo("created", split);
            }
            TableInputSplit[] tableInputSplitArray = splits.toArray(new TableInputSplit[splits.size()]);
            return tableInputSplitArray;
        }
        finally {
            this.closeTable();
        }
    }

    protected boolean includeRegionInScan(byte[] startKey, byte[] endKey) {
        return true;
    }

    public InputSplitAssigner getInputSplitAssigner(TableInputSplit[] inputSplits) {
        return new LocatableInputSplitAssigner((LocatableInputSplit[])inputSplits);
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
        return null;
    }

    @VisibleForTesting
    public Connection getConnection() {
        return this.connection;
    }
}

