/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.gcp.pubsub.emulator;

import com.google.auth.Credentials;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.SubscriberGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.time.Duration;
import org.apache.flink.streaming.connectors.gcp.pubsub.BlockingGrpcPubSubSubscriber;
import org.apache.flink.streaming.connectors.gcp.pubsub.common.PubSubSubscriber;
import org.apache.flink.streaming.connectors.gcp.pubsub.common.PubSubSubscriberFactory;

public class PubSubSubscriberFactoryForEmulator
implements PubSubSubscriberFactory {
    private final String hostAndPort;
    private final String projectSubscriptionName;
    private final int retries;
    private final Duration timeout;
    private final int maxMessagesPerPull;

    public PubSubSubscriberFactoryForEmulator(String hostAndPort, String project, String subscription, int retries, Duration timeout, int maxMessagesPerPull) {
        this.hostAndPort = hostAndPort;
        this.retries = retries;
        this.timeout = timeout;
        this.maxMessagesPerPull = maxMessagesPerPull;
        this.projectSubscriptionName = ProjectSubscriptionName.format((String)project, (String)subscription);
    }

    @Override
    public PubSubSubscriber getSubscriber(Credentials credentials) throws IOException {
        ManagedChannel managedChannel = NettyChannelBuilder.forTarget((String)this.hostAndPort).usePlaintext().build();
        PullRequest pullRequest = PullRequest.newBuilder().setMaxMessages(this.maxMessagesPerPull).setSubscription(this.projectSubscriptionName).build();
        SubscriberGrpc.SubscriberBlockingStub stub = SubscriberGrpc.newBlockingStub((Channel)managedChannel);
        return new BlockingGrpcPubSubSubscriber(this.projectSubscriptionName, managedChannel, stub, pullRequest, this.retries, this.timeout);
    }
}

