/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.gcp.pubsub;

import com.google.pubsub.v1.PubsubMessage;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.gcp.pubsub.common.PubSubDeserializationSchema;
import org.apache.flink.util.Collector;

class DeserializationSchemaWrapper<T>
implements PubSubDeserializationSchema<T> {
    private final DeserializationSchema<T> deserializationSchema;

    DeserializationSchemaWrapper(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    @Override
    public boolean isEndOfStream(T t) {
        return this.deserializationSchema.isEndOfStream(t);
    }

    @Override
    public T deserialize(PubsubMessage pubsubMessage) throws Exception {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    public void deserialize(PubsubMessage message, Collector<T> out) throws Exception {
        this.deserializationSchema.deserialize(message.getData().toByteArray(), out);
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

