/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.util.Arrays;
import org.apache.flink.connector.file.src.util.IteratorResultIterator;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IteratorResultIteratorTest {
    IteratorResultIteratorTest() {
    }

    @Test
    void testGetElements() {
        String[] elements = new String[]{"1", "2", "3", "4"};
        long initialPos = 1422L;
        long initialSkipCount = 17L;
        IteratorResultIterator iter = new IteratorResultIterator(Arrays.asList(elements).iterator(), 1422L, 17L);
        for (int i = 0; i < elements.length; ++i) {
            RecordAndPosition recAndPos = iter.next();
            Assertions.assertThat((String)((String)recAndPos.getRecord())).isEqualTo(elements[i]);
            Assertions.assertThat((long)recAndPos.getOffset()).isEqualTo(1422L);
            Assertions.assertThat((long)recAndPos.getRecordSkipCount()).isEqualTo(17L + (long)i + 1L);
        }
    }

    @Test
    void testExhausted() {
        IteratorResultIterator iter = new IteratorResultIterator(Arrays.asList("1", "2").iterator(), 0L, 0L);
        iter.next();
        iter.next();
        Assertions.assertThat((Object)iter.next()).isNull();
    }
}

