/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.utils;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;

public class FileSinkTestUtils {

    public static class StringIdentityBucketAssigner
    implements BucketAssigner<String, String> {
        private static final long serialVersionUID = 1L;

        public String getBucketId(String element, BucketAssigner.Context context) {
            return element;
        }

        public SimpleVersionedSerializer<String> getSerializer() {
            return SimpleVersionedStringSerializer.INSTANCE;
        }
    }

    public static class SimpleVersionedWrapperSerializer<T>
    implements SimpleVersionedSerializer<T> {
        private final Supplier<T> factory;

        public SimpleVersionedWrapperSerializer(Supplier<T> factory) {
            this.factory = factory;
        }

        public int getVersion() {
            return 1;
        }

        public byte[] serialize(T obj) throws IOException {
            Preconditions.checkState((boolean)(obj instanceof StringValue), (Object)"Only subclass of StringValue is supported");
            return SimpleVersionedStringSerializer.INSTANCE.serialize(((StringValue)obj).getValue());
        }

        public T deserialize(int version, byte[] serialized) throws IOException {
            String value = SimpleVersionedStringSerializer.INSTANCE.deserialize(SimpleVersionedStringSerializer.INSTANCE.getVersion(), serialized);
            T t = this.factory.get();
            Preconditions.checkState((boolean)(t instanceof StringValue), (Object)"Only subclass of StringValue is supported");
            ((StringValue)t).setValue((CharSequence)value);
            return t;
        }
    }

    public static class TestInProgressFileRecoverable
    extends StringValue
    implements InProgressFileWriter.InProgressFileRecoverable {
        private Path path;
        private Path uncommittedPath;
        private long size;

        public TestInProgressFileRecoverable() {
            this.path = null;
            this.uncommittedPath = null;
            this.size = -1L;
        }

        public TestInProgressFileRecoverable(Path path, long size) {
            this.path = path;
            this.uncommittedPath = new Path(path.getParent(), "." + path.getName());
            this.size = size;
        }

        public Path getPath() {
            return this.path;
        }

        public Path getUncommittedPath() {
            return this.uncommittedPath;
        }

        public long getSize() {
            return this.size;
        }

        public String getValue() {
            return this.size + "," + (this.path == null ? "" : this.path.toUri().toString());
        }

        public void setValue(CharSequence value, int offset, int len) {
            String[] arr = value.subSequence(offset, len).toString().split(",");
            this.size = Integer.parseInt(arr[0]);
            Path path = this.path = arr.length == 1 ? null : new Path(arr[1]);
            if (this.path != null) {
                this.uncommittedPath = new Path(this.path.getParent(), "." + this.path.getName());
            }
        }
    }

    public static class TestPendingFileRecoverable
    extends StringValue
    implements InProgressFileWriter.PendingFileRecoverable {
        private Path path;
        private Path uncommittedPath;
        private long size;

        public TestPendingFileRecoverable() {
            this.path = null;
            this.uncommittedPath = null;
            this.size = -1L;
        }

        public TestPendingFileRecoverable(Path path, long size) {
            this.path = path;
            this.uncommittedPath = new Path(path.getParent(), "." + path.getName());
            this.size = size;
        }

        public Path getPath() {
            return this.path;
        }

        public Path getUncommittedPath() {
            return this.uncommittedPath;
        }

        public long getSize() {
            return this.size;
        }

        public String getValue() {
            return this.size + "," + (this.path == null ? "" : this.path.toUri().toString());
        }

        public void setValue(CharSequence value, int offset, int len) {
            String[] arr = value.subSequence(offset, len).toString().split(",");
            this.size = Integer.parseInt(arr[0]);
            Path path = this.path = arr.length == 1 ? null : new Path(arr[1]);
            if (this.path != null) {
                this.uncommittedPath = new Path(this.path.getParent(), "." + this.path.getName());
            }
        }
    }
}

