/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.connector.file.src.util.SingletonResultIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SingletonResultIteratorTest {
    SingletonResultIteratorTest() {
    }

    @Test
    void testEmptyConstruction() {
        SingletonResultIterator iter = new SingletonResultIterator();
        Assertions.assertThat((Object)iter.next()).isNull();
    }

    @Test
    void testGetElement() {
        Object element = new Object();
        long pos = 1422L;
        long skipCount = 17L;
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.set(element, 1422L, 17L);
        RecordAndPosition record = iter.next();
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((Object)record.getRecord()).isNotNull();
        Assertions.assertThat((long)record.getOffset()).isEqualTo(1422L);
        Assertions.assertThat((long)record.getRecordSkipCount()).isEqualTo(17L);
    }

    @Test
    void testExhausted() {
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.set(new Object(), 1L, 2L);
        iter.next();
        Assertions.assertThat((Object)iter.next()).isNull();
    }

    @Test
    void testNoRecycler() {
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.releaseBatch();
    }

    @Test
    void testRecycler() {
        AtomicBoolean recycled = new AtomicBoolean();
        SingletonResultIterator iter = new SingletonResultIterator(() -> recycled.set(true));
        iter.releaseBatch();
        Assertions.assertThat((boolean)recycled.get()).isTrue();
    }
}

