/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream.compact;

import java.util.List;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.connector.file.table.stream.compact.AbstractCompactTestBase;
import org.apache.flink.connector.file.table.stream.compact.CompactFileWriter;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CompactFileWriterTest
extends AbstractCompactTestBase {
    CompactFileWriterTest() {
    }

    @Test
    void testEmitEndCheckpointAfterEndInput() throws Exception {
        CompactFileWriter compactFileWriter = new CompactFileWriter(1000L, (StreamingFileSink.BucketsBuilder)StreamingFileSink.forRowFormat((Path)this.folder, (Encoder)new SimpleStringEncoder()));
        try (OneInputStreamOperatorTestHarness harness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)compactFileWriter);){
            harness.setup();
            harness.open();
            harness.processElement((Object)CompactFileWriterTest.row("test"), 0L);
            harness.snapshot(1L, 1L);
            harness.notifyOfCompletedCheckpoint(1L);
            List coordinatorInputs = harness.extractOutputValues();
            Assertions.assertThat((List)coordinatorInputs).hasSize(2);
            Assertions.assertThat(coordinatorInputs.get(0)).isInstanceOf(CompactMessages.InputFile.class);
            Assertions.assertThat((long)((CompactMessages.EndCheckpoint)coordinatorInputs.get(1)).getCheckpointId()).isEqualTo(1L);
            harness.processElement((Object)CompactFileWriterTest.row("test1"), 0L);
            harness.processElement((Object)CompactFileWriterTest.row("test2"), 0L);
            harness.getOutput().clear();
            harness.endInput();
            coordinatorInputs = harness.extractOutputValues();
            CompactMessages.EndCheckpoint endCheckpoint = (CompactMessages.EndCheckpoint)coordinatorInputs.get(coordinatorInputs.size() - 1);
            Assertions.assertThat((long)endCheckpoint.getCheckpointId()).isEqualTo(Long.MAX_VALUE);
        }
    }

    private static RowData row(String s) {
        return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)s)});
    }
}

