/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch.compact;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemCommitterTest;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.PartitionCommitPolicyFactory;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.connector.file.table.batch.compact.BatchPartitionCommitterSink;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

public class BatchPartitionCommitterSinkTest {
    private final FileSystemFactory fileSystemFactory = FileSystem::get;
    private TableMetaStoreFactory metaStoreFactory;
    private ObjectIdentifier identifier;
    @TempDir
    private java.nio.file.Path path;
    @TempDir
    private java.nio.file.Path outputPath;
    private static final RuntimeContext TEST_RUNTIME_CONTEXT = BatchPartitionCommitterSinkTest.getMockRuntimeContext();
    private static final SinkFunction.Context TEST_SINK_CONTEXT = new SinkFunction.Context(){

        public long currentProcessingTime() {
            return 0L;
        }

        public long currentWatermark() {
            return 0L;
        }

        public Long timestamp() {
            return null;
        }
    };

    @BeforeEach
    public void before() {
        this.metaStoreFactory = new FileSystemCommitterTest.TestMetaStoreFactory(new Path(this.outputPath.toString()));
        this.identifier = ObjectIdentifier.of((String)"hiveCatalog", (String)"default", (String)"test");
    }

    @Test
    public void testPartitionCommit() throws Exception {
        BatchPartitionCommitterSink committerSink = new BatchPartitionCommitterSink(this.fileSystemFactory, this.metaStoreFactory, false, false, new Path(this.path.toString()), new String[]{"p1", "p2"}, new LinkedHashMap(), this.identifier, new PartitionCommitPolicyFactory(null, null, null));
        committerSink.open(new Configuration());
        List<Path> pathList1 = this.createFiles(this.path, "task-1/p1=0/p2=0/", "f1", "f2");
        List<Path> pathList2 = this.createFiles(this.path, "task-2/p1=0/p2=0/", "f3");
        List<Path> pathList3 = this.createFiles(this.path, "task-2/p1=0/p2=1/", "f4");
        HashMap<String, List<Path>> compactedFiles = new HashMap<String, List<Path>>();
        pathList1.addAll(pathList2);
        compactedFiles.put("p1=0/p2=0/", pathList1);
        compactedFiles.put("p1=0/p2=1/", pathList3);
        committerSink.invoke(new CompactMessages.CompactOutput(compactedFiles), TEST_SINK_CONTEXT);
        committerSink.setRuntimeContext(TEST_RUNTIME_CONTEXT);
        committerSink.finish();
        committerSink.close();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f1")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f2")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=0/f3")).exists();
        Assertions.assertThat((File)new File(this.outputPath.toFile(), "p1=0/p2=1/f4")).exists();
    }

    private List<Path> createFiles(java.nio.file.Path parent, String path, String ... files) throws IOException {
        java.nio.file.Path dir = Files.createDirectories(Paths.get(parent.toString(), path), new FileAttribute[0]);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String file : files) {
            paths.add(new Path(Files.createFile(dir.resolve(file), new FileAttribute[0]).toFile().getPath()));
        }
        return paths;
    }

    private static RuntimeContext getMockRuntimeContext() {
        RuntimeContext context = (RuntimeContext)Mockito.mock(RuntimeContext.class);
        ((RuntimeContext)Mockito.doReturn((Object)Thread.currentThread().getContextClassLoader()).when((Object)context)).getUserCodeClassLoader();
        return context;
    }
}

