/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch.compact;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.RowPartitionComputer;
import org.apache.flink.connector.file.table.batch.compact.BatchFileWriter;
import org.apache.flink.connector.file.table.stream.compact.AbstractCompactTestBase;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BatchFileWriterTest
extends AbstractCompactTestBase {
    private final String[] columnNames = new String[]{"a", "b", "c"};
    private FileSystemFactory fsFactory = FileSystem::get;

    @Test
    public void testWriteWithoutPartition() throws Exception {
        String[] partitionColumns = new String[]{};
        BatchFileWriter<Row> fileWriter = this.createBatchFileWriter(this.columnNames, partitionColumns, new LinkedHashMap<String, String>(), false);
        PartitionTempFileManager tempFileManager = new PartitionTempFileManager(this.fsFactory, this.folder, 0, 0, OutputFileConfig.builder().build());
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(fileWriter);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, 2})));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, 2})));
            List coordinatorInputs = testHarness.extractOutputValues();
            this.assertInputFile(coordinatorInputs, 1, Collections.singletonList(""), Collections.singletonList(tempFileManager.createPartitionDir(new String[0])));
        }
    }

    @Test
    public void testWriteWithStaticPartition() throws Exception {
        String[] partitionColumns = new String[]{"b", "c"};
        LinkedHashMap<String, String> staticParts = new LinkedHashMap<String, String>();
        staticParts.put("b", "p1");
        staticParts.put("c", "p2");
        BatchFileWriter<Row> fileWriter = this.createBatchFileWriter(partitionColumns, partitionColumns, staticParts, false);
        PartitionTempFileManager tempFileManager = new PartitionTempFileManager(this.fsFactory, this.folder, 0, 0, OutputFileConfig.builder().build());
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(fileWriter);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, 2})));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, 2})));
            List coordinatorInputs = testHarness.extractOutputValues();
            this.assertInputFile(coordinatorInputs, 1, Collections.singletonList("b=p1/c=p2/"), Collections.singletonList(tempFileManager.createPartitionDir(new String[]{"b=p1/c=p2/"})));
        }
    }

    @Test
    public void testWriteWithoutDynamicPartitionGrouped() throws Exception {
        this.testWriteWithDynamicPartition(false);
    }

    @Test
    public void testWriteWithDynamicPartitionGrouped() throws Exception {
        this.testWriteWithDynamicPartition(true);
    }

    private void testWriteWithDynamicPartition(boolean dynamicGrouped) throws Exception {
        String[] partitionColumns = new String[]{"b", "c"};
        BatchFileWriter<Row> fileWriter = this.createBatchFileWriter(this.columnNames, partitionColumns, new LinkedHashMap<String, String>(), dynamicGrouped);
        PartitionTempFileManager tempFileManager = new PartitionTempFileManager(this.fsFactory, this.folder, 0, 0, OutputFileConfig.builder().build());
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(fileWriter);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, 2})));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 2, 1})));
            List coordinatorInputs = testHarness.extractOutputValues();
            this.assertInputFile(coordinatorInputs, 2, Arrays.asList("b=1/c=2/", "b=2/c=1/"), Arrays.asList(tempFileManager.createPartitionDir(new String[]{"b=1/c=2/"}), tempFileManager.createPartitionDir(new String[]{"b=2/c=1/"})));
        }
    }

    private void assertInputFile(List<CompactMessages.CoordinatorInput> coordinatorInputs, int expectSize, List<String> expectedPartitions, List<Path> expectedFilePaths) {
        Assertions.assertThat(coordinatorInputs).hasSize(expectSize);
        for (int i = 0; i < expectSize; ++i) {
            CompactMessages.CoordinatorInput input = coordinatorInputs.get(i);
            Assertions.assertThat((Object)input).isInstanceOf(CompactMessages.InputFile.class);
            CompactMessages.InputFile inputFile = (CompactMessages.InputFile)input;
            Assertions.assertThat((String)inputFile.getPartition()).isEqualTo(expectedPartitions.get(i));
            Assertions.assertThat((Object)inputFile.getFile()).isEqualTo((Object)expectedFilePaths.get(i));
        }
    }

    private BatchFileWriter<Row> createBatchFileWriter(String[] columnNames, String[] partitionColumns, LinkedHashMap<String, String> staticPartitions, boolean dynamicGrouped) {
        return new BatchFileWriter(this.fsFactory, this.folder, partitionColumns, dynamicGrouped, staticPartitions, TextOutputFormat::new, (PartitionComputer)new RowPartitionComputer("default", columnNames, partitionColumns), OutputFileConfig.builder().build());
    }
}

