/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.DynamicPartitionWriter;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.GroupedPartitionWriter;
import org.apache.flink.connector.file.table.OutputFormatFactory;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.PartitionWriter;
import org.apache.flink.connector.file.table.SingleDirectoryWriter;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PartitionWriterTest {
    private final LegacyRowResource usesLegacyRows = LegacyRowResource.INSTANCE;
    @TempDir
    private java.nio.file.Path tmpDir;
    private PartitionTempFileManager manager;
    private final Map<String, List<Row>> records = new LinkedHashMap<String, List<Row>>();
    private final OutputFormatFactory<Row> factory = (OutputFormatFactory & Serializable)path -> new OutputFormat<Row>(){
        private static final long serialVersionUID = -5797045183913321175L;

        public void configure(Configuration parameters) {
        }

        public void open(int taskNumber, int numTasks) {
            PartitionWriterTest.this.records.put(this.getKey(), new ArrayList());
        }

        private String getKey() {
            Path parent = path.getParent();
            return parent.getName().startsWith("task-") ? parent.getName() : parent.getParent().getName() + "/" + parent.getName();
        }

        public void writeRecord(Row record) {
            ((List)PartitionWriterTest.this.records.get(this.getKey())).add(record);
        }

        public void close() {
        }
    };
    private final PartitionWriter.Context<Row> context = new PartitionWriter.Context(null, (OutputFormatFactory & Serializable)path -> this.factory.createOutputFormat(path));
    private FileSystemFactory fsFactory = FileSystem::get;
    private PartitionComputer<Row> computer = new PartitionComputer<Row>(){

        public LinkedHashMap<String, String> generatePartValues(Row in) {
            LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(1);
            ret.put("p", in.getField(0).toString());
            return ret;
        }

        public Row projectColumnsToWrite(Row in) {
            return in;
        }
    };

    @BeforeEach
    void before() throws IOException {
        this.manager = new PartitionTempFileManager(this.fsFactory, new Path(this.tmpDir.toUri()), 0, 0);
        this.usesLegacyRows.before();
    }

    @AfterEach
    void after() {
        this.usesLegacyRows.after();
    }

    @Test
    void testEmptySingleDirectoryWriter() throws Exception {
        SingleDirectoryWriter writer = new SingleDirectoryWriter(this.context, this.manager, this.computer, new LinkedHashMap());
        writer.close();
        Assertions.assertThat(this.records).isEmpty();
    }

    @Test
    void testSingleDirectoryWriter() throws Exception {
        SingleDirectoryWriter writer = new SingleDirectoryWriter(this.context, this.manager, this.computer, new LinkedHashMap());
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 1}));
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 2}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.close();
        Assertions.assertThat((String)this.records.toString()).isEqualTo("{task-0-attempt-0=[p1,1, p1,2, p2,2]}");
        this.manager = new PartitionTempFileManager(this.fsFactory, new Path(this.tmpDir.toUri()), 1, 0);
        writer = new SingleDirectoryWriter(this.context, this.manager, this.computer, new LinkedHashMap());
        writer.write((Object)Row.of((Object[])new Object[]{"p3", 3}));
        writer.write((Object)Row.of((Object[])new Object[]{"p5", 5}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.close();
        Assertions.assertThat((String)this.records.toString()).isEqualTo("{task-0-attempt-0=[p1,1, p1,2, p2,2], task-1-attempt-0=[p3,3, p5,5, p2,2]}");
    }

    @Test
    void testGroupedPartitionWriter() throws Exception {
        GroupedPartitionWriter writer = new GroupedPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 1}));
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 2}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.close();
        Assertions.assertThat((String)this.records.toString()).isEqualTo("{task-0-attempt-0/p=p1=[p1,1, p1,2], task-0-attempt-0/p=p2=[p2,2]}");
        this.manager = new PartitionTempFileManager(this.fsFactory, new Path(this.tmpDir.toUri()), 1, 1);
        writer = new GroupedPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p3", 3}));
        writer.write((Object)Row.of((Object[])new Object[]{"p4", 5}));
        writer.write((Object)Row.of((Object[])new Object[]{"p5", 2}));
        writer.close();
        Assertions.assertThat((String)this.records.toString()).isEqualTo("{task-0-attempt-0/p=p1=[p1,1, p1,2], task-0-attempt-0/p=p2=[p2,2], task-1-attempt-1/p=p3=[p3,3], task-1-attempt-1/p=p4=[p4,5], task-1-attempt-1/p=p5=[p5,2]}");
    }

    @Test
    void testDynamicPartitionWriter() throws Exception {
        DynamicPartitionWriter writer = new DynamicPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 1}));
        writer.write((Object)Row.of((Object[])new Object[]{"p2", 2}));
        writer.write((Object)Row.of((Object[])new Object[]{"p1", 2}));
        writer.close();
        Assertions.assertThat((String)this.records.toString()).isEqualTo("{task-0-attempt-0/p=p1=[p1,1, p1,2], task-0-attempt-0/p=p2=[p2,2]}");
        this.manager = new PartitionTempFileManager(this.fsFactory, new Path(this.tmpDir.toUri()), 1, 1);
        writer = new DynamicPartitionWriter(this.context, this.manager, this.computer);
        writer.write((Object)Row.of((Object[])new Object[]{"p4", 5}));
        writer.write((Object)Row.of((Object[])new Object[]{"p3", 3}));
        writer.write((Object)Row.of((Object[])new Object[]{"p5", 2}));
        writer.close();
        Assertions.assertThat((String)this.records.toString()).isEqualTo("{task-0-attempt-0/p=p1=[p1,1, p1,2], task-0-attempt-0/p=p2=[p2,2], task-1-attempt-1/p=p4=[p4,5], task-1-attempt-1/p=p3=[p3,3], task-1-attempt-1/p=p5=[p5,2]}");
    }
}

