/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.StreamFormatAdapter;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.connector.file.src.util.Utils;
import org.apache.flink.connector.file.table.LimitableBulkFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class LimitableBulkFormatTest {
    @TempDir
    private java.nio.file.Path path;
    private File file;

    LimitableBulkFormatTest() {
    }

    @BeforeEach
    void prepare() throws IOException {
        this.file = Files.createTempFile(this.path, "prefix", "suffix", new FileAttribute[0]).toFile();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            builder.append(i).append("\n");
        }
        FileUtils.writeFileUtf8((File)this.file, (String)builder.toString());
    }

    @Test
    void test() throws IOException {
        BulkFormat format = LimitableBulkFormat.create((BulkFormat)new StreamFormatAdapter((StreamFormat)new TextLineInputFormat()), (Long)22L);
        BulkFormat.Reader reader = format.createReader(new Configuration(), new FileSourceSplit("id", new Path(this.file.toURI()), 0L, this.file.length(), this.file.lastModified(), this.file.length()));
        AtomicInteger i = new AtomicInteger(0);
        Utils.forEachRemaining((BulkFormat.Reader)reader, s -> i.incrementAndGet());
        Assertions.assertThat((int)i.get()).isEqualTo(22);
    }

    @Test
    void testLimitOverBatches() throws IOException {
        Long limit = 2048L;
        Configuration conf = new Configuration();
        conf.set(StreamFormat.FETCH_IO_SIZE, (Object)MemorySize.parse((String)"4k"));
        BulkFormat format = LimitableBulkFormat.create((BulkFormat)new StreamFormatAdapter((StreamFormat)new TextLineInputFormat()), (Long)limit);
        BulkFormat.Reader reader = format.createReader(conf, new FileSourceSplit("id", new Path(this.file.toURI()), 0L, this.file.length(), this.file.lastModified(), this.file.length()));
        AtomicInteger i = new AtomicInteger(0);
        Utils.forEachRemaining((BulkFormat.Reader)reader, s -> i.incrementAndGet());
        Assertions.assertThat((int)i.get()).isEqualTo(limit.intValue());
    }

    @Test
    void testSwallowExceptionWhenLimited() throws IOException {
        long limit = 1000L;
        LimitableBulkFormat format = (LimitableBulkFormat)LimitableBulkFormat.create((BulkFormat)new StreamFormatAdapter((StreamFormat)new FailedFormat()), (Long)limit);
        BulkFormat.Reader reader = format.createReader(new Configuration(), new FileSourceSplit("id", new Path(this.file.toURI()), 0L, this.file.length()));
        format.globalNumberRead().set(limit + 1L);
        reader.readBatch();
    }

    private static final class FailedReader
    implements StreamFormat.Reader<String> {
        private FailedReader() {
        }

        @Nullable
        public String read() throws IOException {
            throw new RuntimeException();
        }

        public void close() throws IOException {
        }
    }

    private static class FailedFormat
    extends SimpleStreamFormat<String> {
        private FailedFormat() {
        }

        public FailedReader createReader(Configuration config, FSDataInputStream stream) throws IOException {
            return new FailedReader();
        }

        public TypeInformation<String> getProducedType() {
            return Types.STRING;
        }
    }
}

