/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.connector.file.table.FileSystemCommitterTest;
import org.apache.flink.connector.file.table.FileSystemOutputFormat;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.RowPartitionComputer;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileSystemOutputFormatTest {
    @TempDir
    private java.nio.file.Path tmpPath;
    @TempDir
    private java.nio.file.Path outputPath;
    private final TestingFinalizationContext finalizationContext = new TestingFinalizationContext();

    FileSystemOutputFormatTest() {
    }

    private static Map<File, String> getFileContentByPath(java.nio.file.Path directory) throws IOException {
        HashMap<File, String> contents = new HashMap<File, String>(4);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return contents;
        }
        Collection filesInBucket = FileUtils.listFiles((File)directory.toFile(), null, (boolean)true);
        for (File file : filesInBucket) {
            contents.put(file, FileUtils.readFileToString((File)file));
        }
        return contents;
    }

    @BeforeEach
    void before() {
        RowUtils.USE_LEGACY_TO_STRING = true;
    }

    @AfterEach
    void after() {
        RowUtils.USE_LEGACY_TO_STRING = false;
    }

    @Test
    void testClosingWithoutInput() throws Exception {
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, false, false, new LinkedHashMap<String, String>(), new AtomicReference<FileSystemOutputFormat<Row>>());){
            testHarness.setup();
            testHarness.open();
        }
    }

    @Test
    void testNonPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, false, false, new LinkedHashMap<String, String>(), ref);){
            this.writeUnorderedRecords(testHarness);
            Assertions.assertThat(FileSystemOutputFormatTest.getFileContentByPath(this.tmpPath)).hasSize(1);
        }
        ref.get().finalizeGlobal((FinalizeOnMaster.FinalizationContext)this.finalizationContext);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputPath);
        Assertions.assertThat(content.values()).containsExactly((Object[])new String[]{"a1,1,p1\na2,2,p1\na2,2,p2\na3,3,p1\n"});
    }

    private void writeUnorderedRecords(OneInputStreamOperatorTestHarness<Row, Object> testHarness) throws Exception {
        testHarness.setup();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, "p1"}), 1L));
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p1"}), 1L));
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p2"}), 1L));
        testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a3", 3, "p1"}), 1L));
    }

    @Test
    void testOverrideNonPartition() throws Exception {
        this.testNonPartition();
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(true, false, false, new LinkedHashMap<String, String>(), ref);){
            this.writeUnorderedRecords(testHarness);
            Assertions.assertThat(FileSystemOutputFormatTest.getFileContentByPath(this.tmpPath)).hasSize(1);
        }
        ref.get().finalizeGlobal((FinalizeOnMaster.FinalizationContext)this.finalizationContext);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputPath);
        Assertions.assertThat(content).hasSize(1);
        Assertions.assertThat(content.values()).containsExactly((Object[])new String[]{"a1,1,p1\na2,2,p1\na2,2,p2\na3,3,p1\n"});
        Assertions.assertThat((File)new File(this.tmpPath.toUri())).doesNotExist();
    }

    @Test
    void testStaticPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        LinkedHashMap<String, String> staticParts = new LinkedHashMap<String, String>();
        staticParts.put("c", "p1");
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, true, false, staticParts, ref);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a3", 3}), 1L));
            Assertions.assertThat(FileSystemOutputFormatTest.getFileContentByPath(this.tmpPath)).hasSize(1);
        }
        ref.get().finalizeGlobal((FinalizeOnMaster.FinalizationContext)this.finalizationContext);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputPath);
        Assertions.assertThat(content).hasSize(1);
        Assertions.assertThat((String)content.keySet().iterator().next().getParentFile().getName()).isEqualTo("c=p1");
        Assertions.assertThat(content.values()).containsExactly((Object[])new String[]{"a1,1\na2,2\na2,2\na3,3\n"});
        Assertions.assertThat((File)new File(this.tmpPath.toUri())).doesNotExist();
    }

    @Test
    void testDynamicPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, true, false, new LinkedHashMap<String, String>(), ref);){
            this.writeUnorderedRecords(testHarness);
            Assertions.assertThat(FileSystemOutputFormatTest.getFileContentByPath(this.tmpPath)).hasSize(2);
        }
        ref.get().finalizeGlobal((FinalizeOnMaster.FinalizationContext)this.finalizationContext);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputPath);
        TreeMap sortedContent = new TreeMap();
        content.forEach((file, s) -> sortedContent.put(file.getParentFile().getName(), s));
        Assertions.assertThat(sortedContent).hasSize(2);
        Assertions.assertThat(sortedContent).contains(new Map.Entry[]{Assertions.entry((Object)"c=p1", (Object)"a1,1\na2,2\na3,3\n"), Assertions.entry((Object)"c=p2", (Object)"a2,2\n")});
        Assertions.assertThat((File)new File(this.tmpPath.toUri())).doesNotExist();
    }

    @Test
    void testGroupedDynamicPartition() throws Exception {
        AtomicReference<FileSystemOutputFormat<Row>> ref = new AtomicReference<FileSystemOutputFormat<Row>>();
        try (OneInputStreamOperatorTestHarness<Row, Object> testHarness = this.createSink(false, true, true, new LinkedHashMap<String, String>(), ref);){
            testHarness.setup();
            testHarness.open();
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a1", 1, "p1"}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p1"}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a3", 3, "p1"}), 1L));
            testHarness.processElement(new StreamRecord((Object)Row.of((Object[])new Object[]{"a2", 2, "p2"}), 1L));
            Assertions.assertThat(FileSystemOutputFormatTest.getFileContentByPath(this.tmpPath)).hasSize(2);
        }
        ref.get().finalizeGlobal((FinalizeOnMaster.FinalizationContext)this.finalizationContext);
        Map<File, String> content = FileSystemOutputFormatTest.getFileContentByPath(this.outputPath);
        TreeMap sortedContent = new TreeMap();
        content.forEach((file, s) -> sortedContent.put(file.getParentFile().getName(), s));
        Assertions.assertThat(sortedContent).hasSize(2);
        Assertions.assertThat((String)((String)sortedContent.get("c=p1"))).isEqualTo("a1,1\na2,2\na3,3\n");
        Assertions.assertThat((String)((String)sortedContent.get("c=p2"))).isEqualTo("a2,2\n");
        Assertions.assertThat((File)new File(this.tmpPath.toUri())).doesNotExist();
    }

    private OneInputStreamOperatorTestHarness<Row, Object> createSink(boolean override, boolean partition, boolean dynamicGrouped, LinkedHashMap<String, String> staticPartitions, AtomicReference<FileSystemOutputFormat<Row>> sinkRef) throws Exception {
        String[] stringArray;
        String[] columnNames = new String[]{"a", "b", "c"};
        if (partition) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "c";
        } else {
            stringArray = new String[]{};
        }
        String[] partitionColumns = stringArray;
        FileSystemCommitterTest.TestMetaStoreFactory msFactory = new FileSystemCommitterTest.TestMetaStoreFactory(new Path(this.outputPath.toString()));
        FileSystemOutputFormat sink = new FileSystemOutputFormat.Builder().setMetaStoreFactory((TableMetaStoreFactory)msFactory).setTempPath(new Path(this.tmpPath.toString())).setOverwrite(override).setPartitionColumns(partitionColumns).setPartitionComputer((PartitionComputer)new RowPartitionComputer("default", columnNames, partitionColumns)).setFormatFactory(TextOutputFormat::new).setDynamicGrouped(dynamicGrouped).setStaticPartitions(staticPartitions).build();
        sinkRef.set((FileSystemOutputFormat<Row>)sink);
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)new OutputFormatSinkFunction((OutputFormat)sink)), 3, 3, 0);
    }

    private static class TestingFinalizationContext
    implements FinalizeOnMaster.FinalizationContext {
        private TestingFinalizationContext() {
        }

        public int getParallelism() {
            return 1;
        }

        public int getFinishedAttempt(int subtaskIndex) {
            return 0;
        }
    }
}

